/*
 * Decompiled with CFR 0.152.
 */
import Adventure.Commands.CommandFactory;
import Adventure.DataStore.DataStoreXMLRegistry;
import Modules.Consumers.ConsumerFactory;
import Modules.MyParser.HelpperParser;
import Modules.MyParser.INotificarParser;
import Modules.Queues.IDespachador;
import Modules.Queues.IQueue;
import Modules.Queues.MessageFactory;
import Modules.Queues.QueueFactory;
import Modules.Queues.TotalDespachador;
import Modules.TextAnalizer.GenericParser;
import Modules.TextAnalizer.TextAnalizerFactory;
import Modules.streamIn.ConsoleIn;
import Modules.streamOut.IEscribirSalida;
import Modules.streamOut.VentanaOutConsole;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class Faenor
implements INotificarParser {
    private ConsoleIn in;
    private IEscribirSalida out;
    private GenericParser parser;
    private IQueue mens;
    private IQueue consu;
    private IDespachador desp;
    private String gramPath = "./XML/GRAM/";
    private String XMLpath = "./XML/";
    protected static Logger log = Logger.getLogger("ENEUP.Main");

    public void notificar(String comando) {
        log.info(comando);
        if (comando != null) {
            this.parser.notificar(comando);
            this.mens.addFirst(MessageFactory.Build("COMMAND", (Object)this.parser.getCommand()));
            this.desp.despachar();
        }
    }

    public Faenor() {
        Date today = new Date();
        DateFormat dateFormatter = DateFormat.getDateInstance(2);
        String dateOut = dateFormatter.format(today);
        log.warn("---- " + dateOut + " ----");
        this.in = new ConsoleIn(this);
        this.out = new VentanaOutConsole();
        TextAnalizerFactory fact = new TextAnalizerFactory(this.gramPath, "extras.xml", "GramMovimiento.xml", "GramMovimiento.xml");
        fact.addPVC("articulos.xml", "GramGeneral.xml", "GramObjetos.xml");
        fact.addVerb("GramFaenor.xml");
        this.parser = fact.getTextAnalizer();
        DataStoreXMLRegistry reg = new DataStoreXMLRegistry();
        if (!reg.register(this.XMLpath, "GLOBAL")) {
            log.error("Error cargando global.xml");
        }
        if (!reg.register(this.XMLpath, "ROOMS")) {
            log.error("Error cargando rooms.xml");
        }
        if (!reg.register(this.XMLpath, "ACTIONS")) {
            log.error("Error cargando actions.xml");
        }
        this.mens = QueueFactory.GetQueue("main_messages");
        this.consu = QueueFactory.GetQueue("main_consumers");
        ConsumerFactory cf = new ConsumerFactory(this.out, reg, this.mens);
        CommandFactory verb = new CommandFactory(this.out, reg, this.mens);
        try {
            this.consu.addFirst(verb.createConsumer("JustAnAnswerCommand"));
            this.consu.addFirst(verb.createConsumer("WhoAmICommand"));
            this.consu.addFirst(verb.createConsumer("ExCommand"));
            this.consu.addFirst(verb.createConsumer("LookCommand"));
            this.consu.addFirst(verb.createConsumer("GoCommand"));
            this.consu.addFirst(cf.createConsumer("SemanticError"));
            this.consu.addLast(cf.createConsumer("ShowDesc"));
            this.consu.addLast(cf.createConsumer("FakeConsumer"));
        }
        catch (Exception e) {
            log.error("Error en cracion modulo: \n" + e);
        }
        this.desp = new TotalDespachador(this.mens, this.consu);
        HelpperParser.showIntro(reg.getDataStore("GLOBAL"), this.out);
        this.mens.addLast(MessageFactory.Build(3, null));
        this.desp.despachar();
        while (true) {
            this.in.leerLinea();
        }
    }

    static {
        PropertyConfigurator.configure("./logConfig.prop");
    }
}

