! fisica.h versin 1.4
! por El Clrigo Urbatain


! NOTA: el texto explicativo de la librera es largusimo. Si quieres ir al grano,
! busca con tu editor de textos: INICIO_LIBRERIA


! Requerimientos:
! ---------------
!
! Tan slo uno: definir en las constantes del juego lo siguiente:
! Constant persona_verbal=1; ! si el juego usa la librera de mensajes Msg1P.h
! Constant persona_verbal=2; ! si el juego usa la librera de mensajes Mensajes.h
!							! que es la que se usa por defecto.
!
! Si se va a usar otra persona verbal para el juego (por ejemplo, la tercera: que el
! protagonista sea un personaje visible: Juan no puede coger eso, pues ya lleva
! demasiado peso), personalmente recomiendo que se amplie esta librera con permiso
! del autor, definiendo una tercera persona verbal, y ampliando los condicionales de
! la persona verbal a switches con las frases apropiadas para ese personaje. Luego
! que cada cual se busque la vida en redescribir los textos (muy recomendable) a su
! gusto.
!
! De todas formas, si no se define la anterior constante, la librera usa por defecto
! la segunda persona verbal, como se ve al inicio del cdigo.


! OTRAS NOTAS: A lo largo de todo este texto, hablo de "contenedores" refirindome
! tanto a soportes y a recipientes, tal como los trata fisica.h (casi de forma
! general), como slo a recipientes por similitud...
! Pero bueno, lo que importa es que no debes de olvidar, que al programar, el
! atributo "recipiente" es para los contenedores habituales, con interior, tales
! como un armario, o una urna, o una caja, o un coche; y que el atributo "soporte"
! es para contenedores de superficie, tales como la superficie de una mesa, el
! techo de un armario, o una banqueta, o la bandeja del teclado de una mesa de
! oficina. Recuerda, "recipiente" y "soporte".
!
! Cuando hablo de "subobjetos", me suelo referir a los objetos dentro de
! contenedores. Pero recordar que tambin existen los subobjetos componentes de otros,
! tales como los goznes de una puerta, su manivela, el ojo de la cerradura,
! la cerradura. En realidad, si estos subobjetos son de la clase "objeto_fisico"
! sern contabilizados para los clculos de peso y volumen; asi que existen dos
! formas de establecer el peso de un objeto compuesto: Una detallando los pesos y
! volmenes de todos los subobjetos del objeto compuesto, o sea, todos los
! componentes de esa puerta, aparte del peso de lo que sera ese objeto sin los
! subobjetos; lo que permitira pegarle una para a la puerta y llevarnos en el
! inventario el pomo o la manivela, lo cual mola :).
! Y la otra forma sera sin declarar los subobjetos como objetos fsicos; asi estos
! sern inamovibles y tan slo un mero decorado del objeto compuesto; y por tanto
! habr que darle el peso y el volumen slo a la puerta del ejemplo, pasando de los
! subobjetos.
!
! De todas formas se me ocurren mil ejemplos donde conviene un termino medio. Sin ir
! ms lejos, en un juego que estoy programando, tengo


! NOTA GORDA: de momento esta librera est orientada al jugador, asi que no hay
! tratamiento de PSIs... de momento...


! Instrucciones de uso:
! ---------------------
!
!	1) Ante todo, elegir una escala para nuestro juego, apropiada segn el uso que
! le vayamos a dar. Por ejemplo, en un juego tal como Astral con lucha y estadsticas
! de combate internas, es conveniente usar algo del 1 al 100, pudiendo sobrepasarlo
! para cosas muy resistentes o muy pesadas, y que eso se lleve bien con las frmulas
! de las estadsticas. En cambio en un juego como Metamorphoses de Emily Short,
! podemos usar una pequea escala del 0 al 5, haciendo a su vez constantes para
! facilitar el entendimiento de los valores que damos. Por ejemplo:
! 		Constant liviano=0;		! fjate que el objeto que use este peso, no ser
!								! contabilizado por las rutinas y por tanto no
! 		! habra limitaciones para ellos respecto al peso. Esto es til para
!		! objetos que sean casi infinitesimales, como monedas, una pluma,
!		! un papelito, etc; objetos que no merecen la pena ni darles un peso 1,
!		! pues no es til usar una escala muy grande (por ejemplo en gramos reales)
!		! e imaginate que si peso 1 es un 1 kilo, no mola ir dndole 1 kilo a cada
!		! papel, moneda, o pluma que haya en el juego. En seguida nuestros
!		! bolsillos se resentiran.
!		Constant ligero=1;
!		Constant poco_pesado=2;
!		Constant peso_normal=3;
!		Constant muy_pesado=4;
!		Constant pesadsimo=5;
!
! Repetir lo mismo para las otras propiedades de objeto fisico.
! Como recomendacin, para unas escala amplia, yo aconsejo dar valores que sean
! familiares, por ejemplo, el peso en kilos y que el peso mximo que el jugador
! o un PSI pueda cargar, sea de su mismo peso.
! De todas formas es imprescindible un amplio testeo, sea cual sea la escala,
! para comprobar que la carga posible sea aceptable y que el juego sea un
! insufrible trasiego de objetos del inventario al suelo, tan slo por que nos
! hemos pasado con los volmenes o los pesos.
! En cuanto al volumen, yo calculo algo como unas llaves con 1, y luego relacionar
! objeto ms grandes con su rea (ms o menos) por ejemplo una monitor que tenga 80
! centmetros cuadrados???, o podemos tomar slo su altura (40 para el monitor, 10
! para un teclado). Otra forma de aplicar el volumen es comparndolo con el objeto
! de menor volumen: si unas llaves es de volumen 1, una piedra que habra una cabeza
! de volumen 2, esta ocupara toda una mano, un revolver un volumen 2, ocupa la otra
! mano, pues calculamos que el volumen mximo a llevar por el jugador ser de 5, 6,
! 7 u 8, para dar un poco de margen con los objetos livianos como las llaves.
! Este ltimo mtodo era muy usado en los juegos de PAW, pero claro, el inventario
! se llenaba de momento.
!
! Para la propiedad de contundencia (exista o no exista en esta librera),
! yo us en Astral, que fuese el valor de puntos de vida que el objeto quitara
! a un miembro corporal si este fuese golpeado por el objeto con plenas facultades
! de fuerza del agresor. Asi, por defecto, el jugador a pelo, con las manos
! desnudas, quitara unos 5 puntos de vida; con la piedra unos 15 puntos; con la
! barra de hierro unos 30; y con el cubo de basura unos 60. Pero de todas formas,
! todo dependa tambin del peso del objeto, asi que....
!
! En fin, elijas lo que elijas, lo mejor es testear profundamente la jugabilidad de
! los valores que has dado.
!
!	2) Usar la clase objeto_fisico slo para los objetos que sean fsicos en el
! mundo virtual que estamos creando. O sea, un objeto "viento" no necesita de
! peso o de tamao; o un objeto escenario o esttico, tal como una casa o un
! decorado cualquiera, aunque en la realidad pese lo suyo y tenga su bien tamao,
! en tu juego no necesitas ser tan realista y tampoco necesitas definir ese
! escenario u objeto inamovible con objeto_fisico, ni darle parmetros ningunos.
!
! 	3) El jugador tambin debe ser un objeto fsico ms (a menos que sea inmaterial,
! como en "Por la necedad Humana", claro), y debe tener sus propiedades
! correspondientes bien rellenas, sin olvidar el peso mximo y el volumen mximo que
! pueda cargar, y por supuesto recomiendo que sean mximos olgados para que el juego
! sea jugable comodamente.
! Es ms... el jugador NO puede ser el por defecto de la librera, debes definir
! el jugador aparte y ejecutar la rutina "CambiarJugador(objetojugadornuevo)" desde
! "Inicializar".
! La librera se encarga (o se encargar en el futuro) de regular la relacin del
! tamao y peso del jugador con los contenedores de su "talla". O sea, que recomiendo
! que definas todos, absolutamente todos los contenedores del juego con el atributo
! entrable, y que dejes a la librera calcular donde podr o no podr el jugador
! entrar. Esto da mucho juego, y puede resultar muy atractivo: piensa en alicia en
! el pais de las maravillas, o en un juego de magos donde derrepente y por error nos
! transformemos en un ser del tamao de un ratn, tan slo con cambiar los
! parmetros de peso y volumen!!! (en realidad no sera tan sencillo, depende del
! diseo del juego...).
!
!	4) Los recipientes y soportes no necesitan de clases adicionales al ser definidos
! como objeto_fisico para que
! funcionen correctamente, basta con que no te olvides de darles su atributo
! correspondiente y la propiedad de volumen mximo permitido.
!
!	5) Las propiedades de la clase "objeto_fisico" que debes definir para los
! objetos pertinentes son:
!	-peso: es el valor del peso del objeto en concreto, o sea, de ese objeto a
! nivel de programacin; no se almacenar en esa propiedad en ningn momento el peso
! total soportado por ese objeto si lleva subobjetos fsicos. Por ejemplo, si es un
! contenedor, una caja de hierro de 1 kilo, esa propiedad valdr 1 vaca o llena, y
! en cualquier momento del juego. Su valor por defecto es de 0.
!	-volumen: es el valor del volumen del objeto en concreto; sin considerar si
! lleva subobjetos con sus volmenes particulares; es ms... la librera no controla
! de ninguna forma los volmenes anidados. Su valor por defecto es 0.
!	-peso_max: es el peso mximo que ese objeto podr llevar en subobjetos... pero
! pero, pero, de momento slo se aplica al jugador; recuerda que todo esto no se
! aplica al PSIs. Y como vers ms adelante, no se aplica a los contenedores.
! Por defecto tiene el valor de 100.
!	-volumen_max: es el volumen mximo que ese objeto podr acaparar en subobjetos.
! Se aplica al jugador y a los contenedores, pero no a los PSIs. Por defecto vale 100.
!
! NOTA IMPORTANTE: Ests propiedades NO pueden ser rutinas. Esto quiere decir que
! no se pueden hacer cosas de este tipo:
! volumen [;
!	if (self has abierto) return 10;
!	else 					return 5;
! ];
!
! para hacer pesos variables segn
! ciertas propiedades de un objeto, por ejemplo: un paraguas ocupa ms volumen
! abierto que cerrado, y un cajn con doble fondo ser capaz de almacenar ms
! volumen con el fondo quitado que con l, o que el uranio radioactivo tendr menos
! peso pasados ciertos cientos de aos que en la actualidad (corrjanme los fsicos
! nucleares si me equivoco. Ummmmmm que argumento ms interesante el que contemple
! un mismo escenario nuclear pasado x tiempo ;)), debers
! codificarlo en las acciones que modifiquen el estado fsico de ese objeto. Por
! ejemplo, si tenemos un paraguas que aumenta de tamao al abrirlo, hay que
! codificarlo de la siguiente forma (en las acciones abrir y cerrar):
!
! objeto_fisico paraguas "paraguas negro"
! with nombre 'paraguas',
! adjetivos 'negro',
! peso 1,
! volumen 5, ! inicialmente estar cerrado.
! antes [;
!	abrir: self.volumen=10; ! volumen que tendr abierto.
!	cerrar: self.volumen=5; ! volumen que tendr cerrado.
! ],
! has abrible;
!
! Asi mismo, es necesario que el programador controle los efectos secundarios
! que esto pueda producir. Por ejemplo, imaginemos una colchoneta inflable
! automticamente: si la metemos primero en una mochila pequea donde quepa y
! despus pulsamos el botn de inflado.... tendremos una colchoneta de 2 metros
! de largo inflada dentro de una mochila de apenas 30 cm de alto.
! Esto se puede evitar programndolo dentro de la susodicha colchoneta:
!
! antes [;
!	inflar: if (parent(self) has recipiente) "No puedes inflarla ah dentro!";
!		if (parent(self)==jugador) "Sultala antes de inflarla";
!	...
!	...
!	];
!
!	6) Los valores de volumen anidados en recipientes, no se suman, pues doy por
! supuesto que ocupan su interior y no agrandan el volumen del recipiente, tal como
! hace el peso; pero quizs en las superficies o en otros tipos de contenedores
! especiales si convendra sumar el volumen almacenado; algo asi como un globo que
! almacene cantidades de agua o una mesa que al apilar cosas, va ganando altura
! en conjunto; pero esto no est contemplado en la librera y debers buscarte la
! vida si este tipo de cosas es lo que buscas. Pero que no es tan dificil como puedes
! comprobar si miras las frmulas que hacen posible esta librera.
!
! Adems, he puesto que no tiene importancia a la hora de meter cosas en los
! contenedores el peso de los subobjetos (no se controla). Como en el prrafo
! anterior digo, me salen 1000 posibilidades en que si es necesario controlarlo, por
! ejemplo: al meter una piedra pesada en una caja hecha de papel vegetal, o al
! colocar un totem de hierro slido sobre una mesa de cristal; en ambos casos
! molara que el contenedor se rompiese. Pero para eso hay que usar una propiedad
! de "resistencia" o "valor de fragilidad-dureza" o algo por el estilo; quizs
! la misma propiedad de "consistencia" valdra, pero... esto no est previsto en
! esta librera de momento y tendrs que buscarte la vida si este es tu caso.
! Pero no alarmarse, esto no es nada complicado, si el peso que soporta el
! contenedor es superior a cierto valor (la consistencia) pues CRAK!
!
! Hablo de la consistencia, pues ya que lo voy a usar para el clculo de los
! puntos de vida que quitar combinndola con la futura librera de "lucha.h",
! no es nada descabellado pensar que un objeto poco contundente ser bastante
! frgil (por ejemplo: un terrn de arena, o un jarrn). Y encima eso aadido
! a la posibilidad de que los objetos se rompan con los golpes, hacen que flipe en
! colores con las posibilidades de la consistencia jejeje ;) (por ejemplo: al
! estrellar el jarrn en la cabeza de alguien).
!
!	7) Si el modo Debug est activado, las rutinas de la librera irn
! mostrando mensajes de comprobacin.
!
!	8) Si en el juego tienes algunos objetos que no sean objetos_fisicos, porque te
! convenga, procura usar las rutinas que da la librera para obtener las propiedades
! de los objetos fsicos. No se te ocurra hacer rutinas genricas accediendo
! directamente a las propiedades de los objeto_fisicos, ya que asi no chequeas si
! el objeto que use la rutina tendr la propiedad y eso da un error de ejecucin.
! En cambio, todas las rutinas se encargan de comprobar que se es de la clase, y si
! no devuelve 0 para el dato pedido.
!
! Las rutinas son las siguientes:
! -RetornaPropPeso(objeto) devuelve la propiedad peso del objeto.
! -RetornaPropVolumen(objeto) devuelve la propiedad volumen de objeto.
! -RetornaPropPesoMax(objeto) devuelve la propiedad peso_max del objeto.
! -RetornaPropVolumenMax(objeto) retorna la propiedad volumen_max del objeto.
! -CalcularPeso(objeto) calcula el peso, incluido subobjetos, que tiene un objeto.
! -CalcularPesoLlevado(objeto) calcula el peso que lleva en subobjetos, el objeto.
! -CalcularVolumen(objeto) calcula el volumen de un objeto.
! -CalcularVolumenLlevado(objeto) calcula el volumen en subobjetos que lleva objeto.
!
! Adems, si te fijas, en todo el cdigo que define la clase objeto_fisico, no
! encontrars ningn acceso directo a las propiedades de los objetos, todos pasan
! por las rutinas y estas siempre chequean que se est tratando con objetos de la
! clase objeto_fisico.
!
!	9) Y eso es todo, como puedes ver ocupa ms la explicacin que la librera en si:)
! Gusta de leerla que es muy breve, es sencilla, y est comentada.

! COSAS QUE HACER: (* ya hecho, ya solucionado)
!	-Introducir verbos de DEBUG y quitar el modo debug actual que es muy cutre.
!	-Que pasa con los objetos que no son objeto_fisico????? Comprobar:
!		- al coger o meter o sacar, el objeto 'uno' al no ser de la clase, simplemente no ejecuta los cdigos de la clase. Asi que no es problema.
!		- otro problema es que el jugador no sea objeto_fisico. Esto afecta cuando el jugador no fisico si coge, mete, saca objetos fisicos.
!		* y un tercero es que pasa con los contenedores que no sean objeto_fisico. O sea, al meter objetos fsicos en contenedores no fisicos.
!	-problema al mover objetos al lmite del peso, dentro del inventario.

! INICIO_LIBRERIA

System_file;

! Por defecto, la persona verbal es la segunda.

#ifndef persona_verbal;
	Constant persona_verbal=2;
#endif;

!#ifndef TARGET_GLULX;
Constant tope_medida=32767;
!#else;
!Constant tope_medida=2147483647;
!#endif;

! La clase.

Class objeto_fisico
with
peso 0,				! el peso del objeto. Slo de l, eh?, nada de subobjetos
volumen 0,			! el volumen del objeto en si, sin subobjetos.
peso_max 100,		! el peso mximo permitido a llevar en subobjetos, si el
					!	objeto es el jugador.
volumen_max 100,	! el volumen mximo permitido a llevar en subobjetos para
					!	contenedores y para el jugador.

! Ahora la propiedad antes, alberga todas comprobaciones del la librera.

antes [;		! a lo largo del cdigo, "self" se refiere al objeto declarado
Coger, Sacar:			! como objeto_fisico que luego ejecuta estas comprobaciones.

	#ifdef Debug;
		print "[Volumen de ", (el) uno, ": ",uno.volumen, "]^";
		print "[Volumen mximo permitido por ", (el) jugador, ": ",jugador.volumen_max, "]^";
	#endif;

	if (RetornaPropVolumenMax(jugador)<CalcularVolumen(self))	! Si el objeto es demasiado grande
		if (persona_verbal==2)
			"No puedes coger ", (el) uno, ", es demasiado grande.";
		else
			"No puedo coger ", (el) uno, ", es demasiado grande.";
	else {
		if ((CalcularVolumenLlevado(jugador)+CalcularVolumen(self))>RetornaPropVolumenMax(jugador)) {
			if (persona_verbal==2)		! El volumen llevado ms el del objeto nuevo
				"No puedes coger ", (el) uno, ", ya llevas demasiadas cosas.";	! es demasiado para el jugador
			else
				"No puedo coger ", (el) uno, ", ya llevo demasiadas cosas.";
			}
		}

	#ifdef Debug;
		print "[Peso individual de ", (el) uno, ": ",uno.peso, "]^";
		print "[Peso mximo permitido por ", (el) jugador, ": ",jugador.peso_max, "]^";
	#endif;

	if (RetornaPropPesoMax(jugador)<CalcularPeso(self)) {		! El objeto es demasiado pesado
		if (persona_verbal==2)
			"No puedes coger ", (el) uno, ", pesa demasiado para ti.";
		else
			"No puedo coger ", (el) uno, ", pesa demasiado para mi.";
		}
	else {
		if ((CalcularPesoLlevado(jugador)+CalcularPeso(self))>RetornaPropPesoMax(jugador)) {
			if (persona_verbal==2)	! El peso llevado ms el peso del nuevo objeto es demasiado
				"No puedes coger ", (el) uno, ", ya llevas demasiado peso.";
			else
				"No puedo coger ", (el) uno, ", ya llevo demasiado peso.";
			}
		}

meter, ponersobre:	! "otro" se refiere al contenedor

	#ifdef Debug;
		print "[Volumen de ", (el) uno, ": ",uno.volumen, "]^";
		print "[Volumen mximo permitido por ", (el) otro, ": ",otro.volumen_max, "]^";
	#endif;

	if (RetornaPropVolumenMax(otro)<CalcularVolumen(self))	! el volumen de "otro", el contenedor, no es
		if (persona_verbal==2)			! suficiente pa el tamao del objeto a meter
			"No puedes poner ", (el) uno, " en ", (el) otro, ", porque no cabe.";
		else
			"No puedo poner ", (el) uno, "en ", (el) otro, ", porque no cabe.";

	if ((CalcularVolumenLlevado(otro)+CalcularVolumen(self))>RetornaPropVolumenMax(otro))
		if (persona_verbal==2) ! el volumen del contenedor ms el del objeto, es demasiado
			"No puedes poner ", (el) uno, " en ", (el) otro, ", porque no hay espacio.";
		else
			"No puedo poner ", (el) uno, "en ", (el) otro, ", porque no hay espacio.";

meterse:	! Esto pasa cuando el jugador entra o sube a contenedores "entrables"

	#ifdef Debug;
		print "[Volumen del jugador: ",jugador.volumen, "]^";
		print "[Volumen mximo permitido por ", (el) uno, ": ",uno.volumen_max, "]^";
	#endif;

	if (RetornaPropVolumenMax(uno)<CalcularVolumen(jugador))
		if (persona_verbal==2)
			"No cabes en ", (el) uno, ", es demasiado peque", (o) uno, " para ti.";
		else
			"No quepo en ", (el) uno, ", es demasiado peque", (o) uno, " para mi.";

	if ((CalcularVolumenLlevado(uno)+CalcularVolumen(jugador))>RetornaPropVolumenMax(uno))
		if (persona_verbal==2)
			"No cabes en ", (el) uno, " porque no hay espacio suficiente.";
		else
			"No quepo en ", (el) uno, ". No hay espacio suficiente para mi.";

];


! Esta rutina retorna simplemente la propiedad peso del objeto. Comprobando que la tenga al ser de la clase objeto_fisico. Sino devuelve 0.

[ RetornaPropPeso obj res ;
if (obj ofclass objeto_fisico)
	res=obj.peso;
return res;
];

! Y esta retorna la propiedad volumen.

[ RetornaPropVolumen obj res ;
if (obj ofclass objeto_fisico)
	res=obj.volumen;
return res;
];

! Y este retorna la propiedad peso_max

[ RetornaPropPesoMax obj res ;
res=tope_medida;
if (obj ofclass objeto_fisico)
	res=obj.peso_max;
return res;
];

! Y este la propiedad volumen_ max

[ RetornaPropVolumenMax obj res ;
res=tope_medida;
if (obj ofclass objeto_fisico)
	res=obj.volumen_max;
return res;
];

! Esta rutina calcula el peso que un objeto lleva en subobjetos, pero sin considerar
! el suyo propio.

[ CalcularPesoLlevado obj x total;	! Por defecto, las variables declaradas valen 0?
objectloop (x in obj) {				! Recorre los subobjetos del objeto
	if (x ofclass objeto_fisico)	! y slo los que sean de la clase objeto_fisico
		total=total+CalcularPeso(x); ! son sumados al total.
	}
return total;
];

! Y este calcula el peso del objeto real, incluidos los subobjetos y el suyo propio.

[ CalcularPeso obj total ;
	total=0;
	if (obj ofclass objeto_fisico)	! Slo procede si es un objeto_fisico.
		total = (CalcularPesoLlevado(obj)+RetornaPropPeso(obj)); ! elemental...
	return total;
];

! Y esta rutina calcula el volumen en subobjetos sin incluir el propio.

[ CalcularVolumenLlevado obj x total;
objectloop (x in obj) {								! Recorre los suobjetos
	if ((x ofclass objeto_fisico)&(x hasnt puesto))	! que sean fisicos y que no
		total=total+CalcularVolumen(x);		! esten puestos como ropa, sino
													! sera injugable.
	}	! Suma al total el volumen de ese subobjeto.
! Aqui no hace recursin, pues recuerda que el volumen no es acumulativo.

return total;
];

! Y esta rutina devuelve el volumen de un objeto, pero difiere de la anterior
! sobre el peso...

[ CalcularVolumen obj total ;

!	total = 0;
!	if (obj ofclass objeto_fisico)
!		total = (CalcularVolumenLlevado(obj)+RetornaPropVolumen(obj));

! Todo esto est comentado, pues segn la filosofa de la librera, los volmenes
! no se acumulan. Un contenedor no crecer en volumen por los subvolmenes que cargue,
! por tanto, la rutina queda asi de simple:

if (obj ofclass objeto_fisico)
	total=RetornaPropVolumen(obj);	! el volumen propio e inamovible del objeto.

! Pero si conviene por el juego, se puede aplicar la misma filosofa que con los
! pesos y que si se acumule. Piensa por ejemplo en una mesa donde colocas una viga.
! El conjunto resultante si tiene mayor volumen, asi que con los soportes quizs
! si convendra aumentar el volumen cuando el volumen del objeto colocado sea ms
! grande que el volumen del soporte. Pero... recordar que la librera tal como est
! no permite que el objeto a colocar tenga mayor volumen que el contenedor en general
! sea o no sea soporte, asi que de momento nos olvidamos de volmenes anidados.

return total;
];
