room {
  nam = "titles";
  disp = false;
  noinv = true;
  decor = function(s,w)
  p([[
 ^ ^
So then the question was, should I release it?  I could have sat on it
for a year or two and tried to flesh it out to a full-length piece,
but I wasn't especially motivated to do that -- realistically, my choices
were to release it pretty much as-is, or scrap it.^
And in the end, after asking around and thinking about it for myself, 
I decided that hey, some of my favorite songs appeared only as B-sides
to singles or on movie soundtracks, having been declared by the artists
in question to be unworthy of inclusion on a real album; 
if even a couple of people genuinely enjoy the game as much 
as I enjoy those songs, doesn't that make it worth releasing?^^
  ]])
  p(fmt.r("{#next|<i>Adam Cadre, “The Remains of the Game: Reflections on Shrapnel”</i>}"))
  end;
  enter = function ()
    theme_switch('titles')
  end
}:with {
  obj {
    nam = "#next",
    act = function()
      walk 'titles_scroller'
    end
  }
}

local text = {
  { "I.A.G. Alpha", style = 1 },
  { },
  { "-------------" },
  { "I.ncomplete" },
  { "A.dventure " },
  { "G.ame      " },
  { "Alpha      " },
  { "-------------" },
  { },
  { "This preproduction model" },
  { "is developed in Research Institute" },
  { "\"ELECTROPROMSOCTECHINTERACTIVEMACH\"" },
  { "late May 2018" },
  { "and translated Sep 2018" },
  { },
  { },
  { "Author and lead programmer", style = 1 },
  { },
  { "Serhii \"techniX\" Mozhaiskyi" },
  { },
  { },
  { "Testers", style = 1 },
  { },
  { "Vyacheslav \"Cheshire\" Dobranov" },
  { "Peter \"Gl00my\" Kosyh" },
  { "Yurii \"Goraph\" Pavlenko" },
  { "Andrey \"Wol4ik\" Serebrennikov" },
  { },
  { },
  { "Proofreaders of translated text", style = 1 },
  { },
  { "Jack \"dhakajack\" Welch" },
  { "Joshua Grams" },
  { },
  { },
  { "Music", style = 1 },
  { },
  { "Ryan Andersen - Solitude" },
  { "Ryan Andersen - Flawless" },
  { "Ryan Andersen - Rise" },
  { "Dubmood - Intro #14" },
  { "kb - The Product (fr-08)" },
  { "I have wanted for a long time" },
  { "to put titles to this music." },
  { },
  { },
  { "Sources of inspiration", style = 1 },
  { },
  { "game \"The Beginner's Guide\"" },
  { "(author's comments)", style = 2 },
  { },
  { "game \"Magic Circle\"" },
  { "(editing game world)", style = 2 },
  { },
  { "game \"The Stanley Parable\"" },
  { "(talking to player)", style = 2 },
  { },
  { "book \"House of Leaves\"" },
  { "(roof scene textual design)", style = 2 },
  { },
  { "demoscene \"fr-08: .the .product\"" },
  { "(credits roll design)", style = 2 },
  { },
  { "Oh, and there is a reference"},
  { "to the game \"Dear Esther\"." },
  { "Have you found it?"},
  { },
  { },
  { "That’s it! THE END.", style = 1 },
  { "You can now exit the game.", style = 1 },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { "It looks like you're still here :)" },
  { "Fine, let’s keep going." },
  { },
  { "There is almost a minute left" },
  { "until the end of the music track," },
  { "and I have absolutely no idea" },
  { "what else to write here." },
  { },
  { "Initially, I was planning" },
  { "to take my unfinished game," },
  { "add inserts \"From the Author\"" },
  { "and release it like that." },
  { },
  { "But then an interesting idea came to me –" },
  { "what if I let the players themselves" },
  { "fill in the missing bits" },
  { "and finish developing the game for me?" },
  { },
  { "What if I give them the ability" }, 
  { "to edit game objects" },
  { "and will create the puzzles" },
  { "based on that mechanic?" },
  { },
  { "However, I had to limit" },
  { "the player’s editing capability" },
  { "to renaming objects." },
  { },
  { "The mechanics of the debugger is" },
  { "perhaps the most interesting"},
  { "aspect of this game."},
  { },
  { "Therefore, puzzles with that mechanic"},
  { "show up twice as much"},
  { "in release version of the game"},
  { "as in the beta-testing version. :)"},
  { },
  { },
  { "And finally, the answer"},
  { "to the most important question:"},
  { "\"What did the author want", style = 2},
  { "to say with his work?\"", style = 2},
  { },
  { },
  { "If you have a project that you have been" },
  { "working on for a long time" },
  { "(and you have it, I'm sure)," },
  { "and which you cannot finish," },
  { "rescue it from the far corner" },
  { "of your hard drive." },
  { },
  { "Shake off the dust and open a text editor." },
  { },
  { "And write at least one line of text." },
  { },
  { "Or, even better, two lines." },
  { },
  { },
  { },
  { "Do it today." },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { },
  { "Right now." },
}


room {
  nam = 'titles_scroller';
  disp = false;
  noinv = true;
  {
    offset = 0;
    darkbg = sprite.new('theme/dark.png');
    scroller = sprite.new(500, 4800);
  };
  ini = function(s)
    if here() == s then
      s:enter()
    end
  end;
  enter = function(s)
    local fn = 'theme/{RobotoMono-Regular,RobotoMono-Bold,RobotoMono-Italic,RobotoMono-BoldItalic}.ttf'
    local s_font = sprite.fnt(fn, 20)
    local s_font_height = s_font:height()
    local pos = 480
    local ww
    local hh
    local h_pos = 0
    for k, v in ipairs(text) do
      local line = s_font:text(v[1] or ' ', v.color or 'white', v.style or 0)
      ww, hh = line:size()
      pos = pos + s_font_height
      if v.align == 'left' then
        h_pos = 0
      else
        h_pos = math.floor((500 - ww) / 2)
      end
      line:copy(s.scroller, h_pos, pos)
    end
    local scr = sprite.scr()
    s.darkbg:copy(scr, 0, 0);
    title_music_player('snd/title-music.ogg')
    timer:set(28)
    instead.mouse_show(false)
  end;
  timer = function(s)
    local scr = sprite.scr()
    s.darkbg:copy(230, 20, 500, 500, scr, 230, 20);
    s.scroller:draw(0, s.offset, 500, 500, scr, 230, 20);
    s.offset = s.offset + 1
    if s.offset > 4550 then
      timer:stop()
      instead.mouse_show(true)
    end
    return false
  end
}
