obj {
  nam = "DEBUGGER",
  disp = fmt.em("~ DEBUGGER^ "),
  inv = "<< Apply DEBUGGER to target object in the scene or in inventory to view it's source code. Some objects can be renamed. >>",
  used = "This interaction is not possible."
}

menu {
  nam = "close_source",
  disp = " Close",
  act = function()
    close_source()
  end
}

function view_source(tobj)
  fmt.para = false
  fmt.dash = false
  local room_name = 'view_source_code_' .. tobj
  theme_switch('source')
  change_pl(source)
  walk(room_name)
end

function close_source()
  fmt.para = true
  fmt.dash = true
  theme_switch('game')
  change_pl(guest)
end

function trim_str(s)
  return (s:gsub("^%s*(.-)%s*$", "%1"))
end

room {
  nam = "view_source_code_menu";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^room \{
^  name = "Main menu";
^  pic = "gfx/nii.png",
^  decor = "
^    \{#intro|Backstory\} <i>[Nikolai's diaries]</i>
^    <b>\{#play|Start game\}</b>
^    \{#howto|How to play\}
^    Settings
^    About
^  " .. fmt.em("
^  -- TODO: finish the scene on the roof
^  -- TODO: comment out the debugger
^  ")
^  
^  ]] .. fmt.b("-- If you are reading this - please continue playing.^  -- I'll be waiting for you at terminal.") .. [[
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_bench";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Benches</b>";
^  bench_seen = ]] .. tostring(_"bench".bench_seen) .. [[;
^  act = function (self)
^    if self.bench_seen == 0 then
^      p "<b>The benches here were recently renovated, but vandals
^          have already managed to spray paint graffiti all over them.</b>"
^      self.bench_seen = 1
^    else
^      p "<b>Among all of the graffiti, the inscription "I.A.G." 
^         is repeated especially often. That sounds familiar -- 
^         is it a football club or something?</b>"
^      self.bench_seen = 0
^    end
^  end;
^\}
    ]])
  end;
}

room {
  nam = "view_source_code_weather";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Weather</b>";
^  act = "<b>Oh, not the rain again -- I'm not a big fan of rain.
^         And I left the umbrella at home.</b>"
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_parking";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Parking</b>";
^  act = "<b>There are no other parking lots nearby, so people 
^         park their cars here.</b>"
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_adv";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Advertisements</b>";
^  act = "<b>I glance at the ads. A dozen of them offer loans   
^     on favorable terms (yeah, we know how that usually ends),
^     there are a couple help wanted ads and one about
^     selling a car. Nothing special.</b>"
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_door";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Path to Entrance Gate</b>";
^  act = function()
^    enable 'Path to Entrance Gate'
^    p "The inscription on the plaque reads:
^       <b>Institute of Advanced Genomics "Alpha"
^       Entrance Gate #2</b>"
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_personal_passcard";
  disp = false;
  decor = function(s)
    p([[
^obj \{
^  name = "<b>]] .. name_of_myid ..[[</b>",
^  level = ]] .. tostring(_"personal_passcard".level) .. [[,
^  inv = "<b>
^    An ID card for the factory: a plastic card  
^    with an electronic chip. Below my photo, my name
^    is printed on the card: Anton Golubev.
^  </b>"
^\}
    ]])
  end
}


room {
  nam = "view_source_code_security_passcard";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"security_passcard".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}",
^  disp = "]] .. name_of_guardid ..[[",
^  dsc = "Inside, a \{red plastic card\} lies on the table. 
^        It looks like a guard’s ID card.",
^  take = function ()
^    p "I put my hand between through the grill and try to 
^       get the card. Can't reach it -- it's too far."
^    return false
^  end,
^  inv = "
^    The personal ID card of a security guard. It must be 
^    brand new -- it hasn’t even been stamped with a name yet.
^   "
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"security_passcard".HIDDEN_name = s.txt
    end
  end;
}


room {
  nam = "view_source_code_mainhall_tourniquet";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Turnstile",
^  dsc = "In the middle of the hall, there are several \{turnstiles\}.",
^  act = "A panel on the turnstile glows red. It seems that I 
^         cannot pass without an ID card.",
^  used = function (self, tool) 
^    if tool.name == "]] .. name_of_myid ..[[" then
^      p "I swipe the ID card through the turnstile’s cardreader,
^         but nothing happens."
^    elseif tool.name == "]] .. name_of_rod ..[[" then
^      p "I try to turn the turnstile with the metal rod, 
^         but it doesn’t budge. Yeah, it’s certainly sturdy."
^    elseif tool.name == "]] .. name_of_guardid ..[[" then
^      p "The guard’s ID card works. The panel now glows green,
^         inviting me to pass through."
^      enable "Path to Corridor"
^    end
^  end,
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_mainhall_security";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Security Booth",
^  is_seen = ]] .. tostring(_"mainhall_security".is_seen) .. [[,
^  dsc = "A \{security cubicle\} is just to the side of the turnstiles. 
^         I can see a light burning in there through the metal
^         grill set into its small service window.",
^  act = function (self)
^    if self.is_seen then
^      if have("]] .. name_of_guardid ..[[") then
^        p "A large cup of coffee still stands on the table 
^          behind the grill. But I took the ID card -- it was
^          a bad idea to have left it unattended."
^      else
^        p "The security console is visible behind the grill.
^           Next to it, on the table, there is a large cup  
^           and a red ID card. This bozo even forgot his ID!"
^        enable "]] .. name_of_guardid ..[["
^      end
^    else
^      self.is_seen = true
^      p "The security booth is empty. It seems that the guard 
^         left the post and went away somewhere.
^         I shouted several times, but the guard did not appear.
^         Where is he?"
^    end
^  end,
^  used = function (self, tool) 
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "I hit the grill with the metal rod, hoping 
^        to summon the guard. Useless."
^    end
^  end,
^  obj = \{
^    _"]] .. name_of_guardid ..[[":disable(),
^  \}
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_mainhall_boxes";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Boxes",
^  is_seen = ]] .. tostring(_"mainhall_boxes".is_seen) .. [[,
^  dsc = function (self)
^    if not self.is_seen then
^      p "On the right near the wall are \{some boxes\}."
^    else
^      p "To the right of the wall, 
^         there are \{boxes with spare parts\}."
^    end
^  end,
^  act = function (self)
^    if self.is_seen then
^      p "The spare parts in the boxes gleamed with an oily sheen.
^         Completely new."
^    else
^      self.is_seen = true
^      p "In the boxes are some spare parts just like the ones
^         made in the factory. But I had thought it hadn’t been
^         operational for a long time..."
^    end
^    if not have("]] .. name_of_rod ..[[") then
^      p "I notice a metal rod in one of the boxes."
^      enable("]] .. name_of_rod ..[[")
^    end
^  end,
^  used = function (self, tool) 
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "I hit the box with the rod."
^    end
^  end,
^  obj = \{
^    _"]] .. name_of_rod ..[[":disable(),
^  \}
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_mainhall_clock";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Clock",
^  dsc = "On the wall to the left hangs a huge electronic \{clock\}
^         with glowing green digits.",
^  act = "The clock says 3:55 PM. What is going on? It's morning now, 
^         that's for sure. Is there really nobody who can set
^         the right time?",
^  used = function (self, tool) 
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "I swing and throw the metal rod on the clock. This makes 
^         a racket as the pieces of the clock fell to the floor.
^         Why did I do this?
^         I pick up the metal rod from the floor -- it may still be
^         useful to me."
^      remove(self)
^    end
^  end,
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_box_detail";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"box_detail".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  disp = "]] .. name_of_rod ..[[",
^  dsc = "Among other odds and ends in the box there is a metal \{rod\}.",
^  take = "I take the rod.",
^  inv = "A metal rod, about a foot and a half long.",
^  use = function (self, target)
^    if target.name == "]] .. name_of_guardid ..[[" then
^      p "Using the rod, I manage to pull the card closer.
^          I put my hand through the grill and take red ID card."
^      -- Add "]] .. name_of_guardid ..[[" to inventory
^      take("]] .. name_of_guardid ..[[")
^      --
^    end
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"box_detail".HIDDEN_name = s.txt
    end
  end;
}


room {
  nam = "view_source_code_labentrance_plant";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Plant",
^  dsc = "By the window, there is a \{plant\} in a huge pot. "
^  act = function ()
^    p "In the five years that I've worked here, I have not 
^        bothered to find out what it is. I know for sure that 
^        it's not a ficus."
^    if _"Fourth floor".search_password and not have("]] .. name_of_smallkey .. [[") then
^      p "I go a bit closer to the pot and notice 
^         a small key behind the stem of the plant."
^      enable("]] .. name_of_smallkey .. [[")
^    end
^  end,
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "Having nothing better to do, I stick the metal rod into
^         the ground and suddenly catch sight of something 
^         behind the plant’s stem. Is it a key?"
^      enable("]] .. name_of_smallkey .. [[")
^    end
^  end,
^  obj = \{
^    _"]] .. name_of_smallkey .. [[":disable()
^  \},
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_lounge";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Armchairs",
^  dsc = "There are also two \{armchairs\} "
^  act = "There is no question that these chairs remember 
^        the <i>perestroika</i> era -- and they look it. 
^        We should have replaced them with new ones years ago."
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_newspaper";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Nespaper",
^  dsc = "On the table is a current \{newspaper\}.",
^  act = function ()
^    walk("Read Newspaper")
^  end,
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_labentrance_table";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Table",
^  dsc = "and a \{coffee table\}.",
^  act = function ()
^    p "Usually, the only thing on the table is dust. But today's 
^       newspaper now lies on it. Apparently, 
^       our "security guy" brought it."
^    enable("Newspaper")
^    if _"Fourth floor".search_password then
^      p "I look under the table. Of course, there is nothing
^         on the bottom. It was silly to expect that the password
^         would be in such a prominent place."
^    end
^  end,
^  obj = \{
^    _"Newspaper":disable()
^  \}
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_labentrance_security_terminal";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Terminal",
^  is_seen = ]] .. tostring(_"labentrance_security_terminal".is_seen) .. [[,
^  dsc = "On the desk is a \{security terminal\}.",
^  act = function ()
^    walk 'interact_security_terminal'
^  end,
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_myid ..[[" or tool.name == "]] .. name_of_guardid ..[[" then
^      p "It looks like I need to launch the program first."
^    elseif tool.name == "]] .. name_of_rod ..[[" then
^      p "Well, no, I need the terminal in one piece."
^    end
^  end
^\}
    ]])
  end;
}




room {
  nam = "view_source_code_labentrance_security_phone";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Phone",
^  dsc = "Next to it is an old \{dial phone\}.",
^  act = function ()
^    if _"Fourth floor".search_password then
^      p "I turned the phone over, expecting to see a sticker 
^         with a password. But there wasn’t any."
^    else
^      p "I picked up the phone. Instead of the usual ringtone,
^         there was a rustling in the receiver. I even thought 
^         that I heard someone's voice, but I could not 
^         make out the words.
^         I waited a few seconds and hung up. It is high time
^         to dump these ancient phones and have a modern
^         PBX installed."
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_security";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Security desk",
^  is_seen = ]] .. tostring(_"labentrance_security".is_seen) .. [[,
^  dsc = "The \{security desk\} is on the left. ",
^  act = function (self)
^    if self.is_seen == false then
^      p "Our guard likes to call himself "The Security Guy". 
^         Let him call himself whatever he wants as long as he
^         does his job. But where did he go? He probably went 
^         to the front gate to smoke with the new recruit."
^      enable("Terminal")
^      enable("Phone")
^      self.is_seen = true
^    else
^      p "There is nothing else on the desk, except for the terminal
^         and the phone."
^      if _"Fourth floor".search_password then
^        p "I suspect that it is worth examining the desk drawers,
^           perhaps there is a paper inside with a password
^           or at least a hint."
^        enable("Desk drawers")
^        enable("Storage compartment")
^      end
^    end
^  end,
^  obj = \{
^    _"Terminal":disable(),
^    _"Phone":disable(),
^    _"Desk drawers":disable(),
^    _"Storage compartment":disable(),
^    _"Papers":disable(),
^  \}
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_security_box";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Desk drawers",
^  is_open = ]] .. tostring(_"labentrance_security_box".is_open) .. [[,
^  dsc = "On the side of the desk there is a \{drawer\} ",
^  act = function (self)
^    if self.is_open then
^      p "In the drawer are some papers."
^      enable "Papers"
^    else
^      p "I pull the handle. Apparently, the drawer is locked."
^    end
^  end,
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "Using the metal rod as a lever, I broke the drawer."
^      self.is_open = true
^    elseif tool.name == "]] .. name_of_smallkey .. [[" then
^      p "I open the drawer with the key."
^      self.is_open = true
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_security_tumb";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Storage compartment",
^  dsc = "and a \{storage compartment\}.",
^  act = "In the storage compartment stand a cup, a kettle, a box
^         of sugar and a packet of cookies. I’m not sure
^         if I need any of this."
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_papers";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Papers",
^  dsc = "There are some \{papers\} in the drawer.",
^  act = function ()
^    p "In a small bundle of papers, I found an invoice for the 
^       purchase of a plant (it turned out to be called monstera),
^       some instructions and job applications, and a yellow 
^       Post-It note with the inscription "MindIsABlackBox", under
^       which someone penciled in "Don’t forget to change." 
^       I hope that he had forgotten to change the password..."
^    _"Fourth floor".search_password = false
^    _"Fourth floor".password_found = true
^  end,
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_labentrance_door";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Door",
^  dsc = "Ahead is the \{door\} leading to our complex.
^         It is equipped with a card reader.",
^  act = "The door is securely closed. I need to use 
^         the ID card to get inside.",
^  used = function (self, tool) 
^    if tool.name == "]] .. name_of_myid ..[[" then
^      if _"]] .. name_of_myid ..[[".level < 3 then
^        p "I swipe my ID card through the reader. 
^           The message "Insufficient access level" 
^           appears on the display."
^      else
^        p "I swipe guard's ID card through the reader. 
^           The indicator changes color to green, 
^           and hear the lock click. Finally, 
^           I can get to my workplace."
^        enable("Path to Block 4А")
^      end
^    elseif tool.name == "]] .. name_of_guardid ..[[" then
^      p "I swipe a card through the reader, but the indicator 
^         said that the access level of this card is not 
^         sufficient. It seems that the guard's card 
^         doesn't work here."
^    end
^  end
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_box_key";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"box_key".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}",
^  disp = "<b>]] .. name_of_smallkey .. [[</b>",
^  dsc = "<b>A \{small key\} lies behind the stem of the plant.</b>",
^  take = "<b>I take the key and put it in my pocket.</b>",
^  inv = "<b>A small key. The sort that might fit a lock
^         on a desk drawer.</b>"
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"box_key".HIDDEN_name = s.txt
    end
  end;
}



room {
  nam = "view_source_code_corridor_4a_door_blockb4";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Door to Block 4B",
^  is_seen = ]] .. tostring(_"corridor_4a_door_blockb4".is_seen) .. [[,
^  dsc = function (self)
^    if self.is_seen then
^      p "The \{door to Block 4B\} is closed."
^    else
^      p "The \{door to the left\} seems to be closed."
^    end
^  end,
^  act = function (self)
^    p ""Block 4B" is written on the door in big letters."
^    enable('Padlock')
^    self.is_seen = true
^  end,
^  obj = \{
^    'Padlock':disable()
^  \},
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_block_b4_lock";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Padlock",
^  is_processed = ]] .. tostring(_"block_b4_lock".is_processed) .. [[,
^  dsc = "There is a massive \{padlock\} on it.",
^  act = "A key is required to open it.",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "I try to break the padlock with a metal rod. 
^         Useless -- the lock is very durable."
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_corridor_4a_door_security";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Door to guard post",
^  is_seen = ]] .. tostring(_"corridor_4a_door_security".is_seen) .. [[,
^  dsc = function (self)
^    if self.is_seen then
^      p "Behind the door to the right is the guard post."
^    else
^      p "On the right is a \{metal door\} with some kind of sign."
^    end
^  end,
^  act = function (self)
^    p "The sign on the door reads "Guard post". 
^       I checked the door -- it isn't locked."
^    enable("Path to Guard Post")
^    self.is_seen = true
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_corridor_4a_p2";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Corridor 4A",
^  is_seen = ]] .. tostring(_"corridor_4a_p2".is_seen) .. [[,
^  dsc = "Ahead, at the \{end of the corridor\}, I can
^         see a few more doors."
^  act = function (self)
^    p "That’s where my desk is. I have to visit it."
^    enable("Path to Corridor End")
^    remove(self)
^  end
^\}
    ]])
  end;
}




    
room {
  nam = "view_source_code_divan";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Sofa",
^  dsc = "There is a comfortable \{sofa\} near the wall. ",
^  act = "Alas, I have no time to rest."
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_tv";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "TV",
^  dsc = "Opposite the sofa, there is a \{TV\} on the table.",
^  act = "The TV screen is covered with dust."
^\}
    ]])
  end;
}

room {
  nam = "view_source_code_journal";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Visit Logs",
^  dsc = "A \{list of visit logs\} is on the table by the window.",
^  act = "The last log entry is dated May 2002, ten years ago.
^         But where is the new log?"
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_terminal_secwindow";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Guard Post Terminal",
^  dsc = "A \{terminal\} stands nearby.",
^  act = "It doesn't turn on. Isn’t anything working around here?"
^\}
    ]])
  end;
}

room {
  nam = "view_source_code_freezer";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Fridge",
^  dsc = "There is a big \{fridge\} in the corner.",
^  act = "The fridge is empty."
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_diner_table";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Dining Table",
^  dsc = "Near the wall there is a \{dining table\} 
^         and around it, several chairs.",
^  act = "Dishes have been tossed haphazardly on the table."
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_writing_desk";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Desk",
^  dsc = "Next to the window was a \{desk\} ",
^  act = "The drawers of the desk are empty."
^\}
    ]])
  end;
}

room {
  nam = "view_source_code_broken_computer";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Broken computer",
^  dsc = "with a \{computer\}.",
^  act = "This piece of junk is ten years old, no less. 
^         Where did they get this crap?"
^\}
    ]])
  end;
}

room {
  nam = "view_source_code_my_desk";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "My Desk",
^  dsc = "I worked here behind a comfortable desk with \{drawers\}.",
^  act = "The drawers of the desk are empty.
^         Where did all my notes go?"
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_workspace_mypc";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "My Computer",
^  dsc = "On the desk is my \{work computer\}.",
^  act = function()
^    walk("Use Computer")
^  end,
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_rod ..[[" then
^      p "Well, no, I need this computer."
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_workspace_mfu";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "Three-In-One Device",
^  dsc = "A three-in-one \{printer/scanner/fax\} is connected to it.",
^  act = "In addition to the usual conveniences, this multi-function
^          printer also has a module to scan film.",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_fotoplenka .. [[" then
^      p "This device can’t scan the undeveloped film."
^    elseif tool.name == "]] .. name_of_rod ..[[" then
^      p "Why should I destroy my employer’s property?"
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_photo_smena";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"photo_smena".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  disp = "<b>]] .. name_of_camera .. [[</b>",
^  dsc = "<b>On the floor is an old \{film camera\}.</b>",
^  take = "<b>I take the camera.</b>",
^  inv = function ()
^    p "<b>
^      Opening the lid of the camera, I take out 
^      a film cartridge with the inscription "Svema."</b>
^    "
^    <i>-- Add "]] .. name_of_fotoplenka .. [[" to inventory</i>
^    take("<b>]] .. name_of_fotoplenka .. [[</b>")
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"photo_smena".HIDDEN_name = s.txt
    end
  end;
}


room {
  nam = "view_source_code_photo_film";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"photo_film".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  disp = "]] .. name_of_fotoplenka .. [[",
^  take = "I take the film cartridge.",
^  inv = "The film is undeveloped. I don’t want to expose it."
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"photo_film".HIDDEN_name = s.txt
    end
  end;
}


room {
  nam = "view_source_code_vc_door";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Computer Lab Door</b>",
^  is_locked = ]] .. tostring(_"vc_door".is_locked) .. [[, <i>-- locked by default</i>
^  disp = "<b>Door</b>",
^  dsc = "<b>There is a \{door\} at the end of the hall.</b>",
^  act = function (self)
^    if self.is_locked then
^      p "<b>The door is locked.</b>"
^    else
^      p "<b>The door is opened.</b>"
^    end
^  end,
^  used = function (self, tool)
^    if tool.name == "<b>]] .. name_of_key .. [[</b>" then
^      p "<b>I turn the key in the lock and the door opens.</b>"
^      self.is_locked = false     <i>-- unlock door</i>
^      enable('Exit to Corridor') <i>-- activate path</i>
^    else
^      p "<b>This door can only be opened with a key.</b>"
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_vc_paper";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"vc_paper".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  disp = "<b>]] .. name_of_paper .. [[</b>",
^  dsc = "<b>A \{scrap of paper\} is on the floor.</b>",
^  act = function ()
^    p "<b>The typewritten scrap is part of a user manual:
^       "The DEBUGGER is designed to modify objects when 
^       the subject is located <...> object names can be 
^       renamed. However, the internal logic governing object
^       behavior cannot be modified, because <...> add  
^       the capability to editfeatures of the location 
^       until Febr <...> ief of lab <...> tech <...></b>"
^    return true
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"vc_paper".HIDDEN_name = s.txt
    end
  end;
}





room {
  nam = "view_source_code_electricity";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Switch Box</b>",
^  is_fixed = ]] .. tostring(_"electricity".is_fixed) .. [[,
^  dsc = "Nearby you could see an open electrical \{switch box\}.",
^  act = function (self)
^    if self.is_fixed then
^      p "Everything looked okay."
^    else
^      p "It looks like there was a short and the wire to the
^         switch labelled "Storage" melted through. Some tape
^         could help here, but where could I get it?"
^    end
^  end,
^  used = function (self, tool)
^    if self.is_fixed then
^      p "If it’s not broken, don’t fix it!"
^    elseif tool.name == "]] .. name_of_tape .. [[" then
^      p "I de-energize the switch box, wind the tape 
^         around two ends of the melted wire and click
^         the switch. That seemed to have done the job!"
^      -- Turn on the light in Storage room
^      _'Storage'.has_light = true
^      -- mark Switch Box as fixed
^      self.is_fixed = true
^    end
^    p "That would not help here."
^  end
^\}
    ]])
  end;
}





room {
  nam = "view_source_code_light_socket";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Light socket</b>",
^  dsc = "A \{light socket\} hangs from the wall by a wire.",
^  act = "It looks intact.",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_lightbulb .. [[" then
^      if lookup("]] .. name_of_brokenlightbulb .. [[") then
^        p "First, you need to unscrew the burned-out light bulb."
^      elseif tool.is_ok then
^        p "I screw the light bulb into the socket. It takes 
^           only one research institute employee to change
^           a light bulb!"
^        place(tool) -- place object to scene
^        here().has_lightbulb = true
^      else
^        p "I don’t see the point of replacing
^           the burned-out light bulb."
^      end
^    elseif tool.name == "]] .. name_of_brokenlightbulb .. [[" then
^      p "I don’t see the point of replacing
^         the burned-out light bulb."
^    end
^  end
^\}
    ]])
  end;
}



room {
  nam = "view_source_code_broken_lightbulb";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"broken_lightbulb".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  is_ok = false,
^  dsc = "In the light socket, there is a \{burned-out light bulb\}."
^  act = "Too high!",
^  inv = "A hundred watt incandescent bulb.
^         Alas, it is useless now.",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_ladder .. [[" and not have(self) then
^      p "I climb the ladder and unscrew
^         the burned-out light bulb."
^      -- Take object to inventory
^      take(self)
^    end
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"broken_lightbulb".HIDDEN_name = s.txt
    end
  end;
}



room {
  nam = "view_source_code_lightbulb";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"lightbulb".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  is_ok = true,
^  dsc = "A lone \{light bulb\} hangs from the ceiling."
^  act = "Too high!",
^  inv = "A new incandescent light bulb.",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_ladder .. [[" and not have(self) then
^      p "I climb the ladder and unscrew the light bulb."
^      -- Take object to inventory
^      take(self)
^      -- mark that the lightbulb is taken
^      here().has_lightbulb = false
^    end
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"lightbulb".HIDDEN_name = s.txt
    end
  end;
}


room {
  nam = "view_source_code_topor";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"topor".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "<b>{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}</b>",
^  is_fixed = ]] .. tostring(_"topor".is_working) .. [[, <i>-- fix axe to use it</i>
^  disp = "<b>]] .. name_of_topor .. [[</b>",
^  dsc = function (self)
^    if self.is_working then
^      p "<b>The \{axe\} lies on the floor.</b>"
^    else
^      p "<b>On the floor is an \{axe\} with a cracked handle.</b>"
^    end
^  end,
^  <i>-- FIXME: add 'take' function to make axe takeable</i>
^  inv = function (self)
^    if self.is_fixed then
^      p "<b>An excellent, sharp axe.</b>"
^    else
^      p "<b>
^        The axe has a cracked handle, making it dangerous to use.
^        How can I fix it?
^      </b>"
^    end
^  end,
^  used = function (self, tool)
^    if tool.name == "<b>]] .. name_of_tape .. [[</b>" then
^      p "<b>
^        I carefully wind tape around the handle of the axe.
^        I hope that's enough.
^      </b>"
^      self.is_working = true <i>-- now player can use axe</i>
^    end
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"topor".HIDDEN_name = s.txt
    end
  end;
}

room {
  nam = "view_source_code_wood";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Boards</b>",
^  dsc = "
^    The stairway to the roof is securely \{boarded up\}.
^  ",
^  act = "
^    The boards are firmly fastened in place. I need to break them.
^  ",
^  used = function (self, tool)
^    if tool.name == "<b>]] .. name_of_topor .. [[</b>" then
^      <i>-- check if axe is fixed</i>
^      if tool.is_fixed then
^        p "<b>With an axe, I quickly chop through the boards.
^            The way is clear.</b>"
^        self:disable()       <i>-- remove boards</i>
^        enable("To Roof")  <i>-- open the way</i>
^      else
^        p "<b>I can't cut the boards with a broken axe.</b>"
^      end
^    else
^      p "<b>I can't break the boards in that manner.</b>"
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_armatura";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Rebar</b>",
^  is_strong = ]] .. tostring(_"armatura".is_strong) .. [[,
^  with_ruslan = ]] .. tostring(_"armatura".with_ruslan) .. [[,
^  dsc = "\{Rebar\} sticks out from the crumbling concrete.",
^  act = "
^    The rebar itself looks strong enough, but not so the concrete.
^    A couple blows on the rebar would be enough to send
^    Ruslan tumbling.
^  ",
^  used = function (self, tool)
^    if tool.name == "]] .. name_of_kuvalda .. [[" then
^      if tool.is_working then
^        if not self.with_ruslan then
^          p "Why hit the rebar for no reason?"
^        elseif self.is_strong then
^          p "A single blow and the concrete crumb crashes down to
^            the asphalt.^"Hey! What are you doing?!" shouts
^            Ruslan. "Stop it!""
^          self.is_strong = false
^        else
^          -- to the final scene --
^          walk("Final Scene")
^        end
^      else
^        p "I cannot hit the rebar with a broken sledgehammer."
^      end
^    elseif tool.name == "]] .. name_of_ruslan .. [[" then
^      p "Ruslan still hangs, clinging to the rebar."
^      self.with_ruslan = true
^    end
^  end
^\}
    ]])
  end;
}


room {
  nam = "view_source_code_ruslan";
  disp = false;
  txt = '';
  enter = function(s)
    s.txt = _"ruslan".HIDDEN_name
  end,
  decor = function(s)
    p([[
^obj \{
^  name = "{@keyboard "Object name", "]] .. s.txt ..[["|]] .. s.txt .. [[}",
^  disp = "<b>]] .. name_of_ruslan .. [[</b>",
^  is_standing = ]] .. tostring(_"ruslan".is_standing) .. [[,
^  dsc = function (self)
^    if self.is_standing then
^      p "\{Ruslan\} stands on the edge of the roof
^         looking nervously downward."
^    else
^      p "\{Ruslan\} hangs precariously from it.
^         The slightest twist and he may fall."
^    end
^  end,
^  act = function (self)
^    if self.is_standing then
^      p "
^        "It seems that this scene will end only if I 
^        fall down," Rusland sighs. "Come on, come up 
^        with something."
^      "
^    else
^      p "I need to do something. But what? Save Ruslan
^         or let him fall off the roof?"
^    end
^  end
^\}
    ]])
  end;
  onkbd = function (s, input_str)
    local input = trim_str(input_str)
    if input ~= '' then
      s.txt = input;
      _"ruslan".HIDDEN_name = s.txt
    end
  end;
}

room {
  nam = "view_source_code_roof_edge";
  disp = false;
  txt = '';
  decor = function(s)
    p([[
^obj \{
^  name = "<b>Edge of the Roof</b>",
^  dsc = "Raindrops drum down on the concrete \{edge of the roof\}.",
^  act = "Rebar sticks out in several places where the
^         concrete has crumbled."
^\}
    ]])
  end;
}


