obj {
  nam = "mainhall_tourniquet",
  disp = "Turnstile",
  dsc = [[In the middle of the hall, there are several {turnstiles}.]],
  act = [[A panel on the turnstile glows red. It seems that I cannot pass without an ID card.]],
  used = function (s,w) 
    if w^'DEBUGGER' then
      view_source('mainhall_tourniquet')
      return
    elseif w.HIDDEN_name == name_of_myid then
      p [[I swipe the ID card through the turnstile’s cardreader, but nothing happens.]]
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[I try to turn the turnstile with the metal rod, but it doesn’t budge. Yeah, it’s certainly sturdy.]]
      return
    elseif w.HIDDEN_name == name_of_guardid then
      p [[The guard’s ID card works. The panel now glows green, inviting me to pass through.]]
      enable "path_mainhall2"
      return
    end
    return false
  end,
}

obj {
  nam = "mainhall_security",
  is_seen = false,
  disp = "Security Booth",
  dsc = [[^A {security cubicle} is just to the side of the turnstiles. I can see a light burning in there through the metal grill set into its small service window.]],
  act = function(s)
    if s.is_seen then
      if have "security_passcard" then
        p [[A large cup of coffee still stands on the table behind the grill. But I took the ID card -- it was a bad idea to have left it unattended.]]
      else
        p [[The security console is visible behind the grill. Next to it, on the table, there is a large cup and a red ID card. This bozo even forgot his ID!]]
        enable "security_passcard"
      end
    else
      s.is_seen = true
      p [[The security booth is empty. It seems that the guard left the post and went away somewhere.^]]
      p [[I shouted several times, but the guard did not appear.  Where is he?]]
    end
  end,
  used = function (s,w) 
    if w^'DEBUGGER' then
      view_source('mainhall_security')
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[I hit the grill with the metal rod, hoping to summon the guard. Useless.]]
      return
    end
    return false
  end
}

obj {
  nam = "mainhall_boxes",
  is_seen = false,
  disp = "Boxes",
  dsc = function(s)
    pn()
    if not s.is_seen then
      p [[^On the right near the wall are {some boxes}.]]
    else
      p [[^To the right of the wall, there are {boxes with spare parts}.]]
    end
  end,
  act = function(s)
    if s.is_seen then
      p [[The spare parts in the boxes gleamed with an oily sheen. Completely new.]]
    else
      s.is_seen = true
      p [[In the boxes are some spare parts just like the ones made in the factory. But I had thought it hadn’t been operational for a long time...]]
    end
    if not have "box_detail" then
      p [[^I notice a metal rod in one of the boxes.]]
      enable "box_detail"
    end
  end,
  used = function (s,w)
    if w^'DEBUGGER' then
      view_source('mainhall_boxes')
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[I hit the box with the rod.]]
      return
    end
    return false
  end,
  obj = {
    _"box_detail":disable(),
  }
}


obj {
  nam = "mainhall_clock",
  disp = "Clock",
  dsc = [[^On the wall to the left hangs a huge electronic {clock} with glowing green digits.]],
  act = "The clock says 3:55 PM. What is going on? It's morning now, that's for sure. Is there really nobody who can set the right time?",
  used = function (s,w)
    if w^'DEBUGGER' then
      view_source('mainhall_clock')
      return
    elseif w.HIDDEN_name == name_of_rod then
      p [[I swing and throw the metal rod on the clock. This makes a racket as the pieces of the clock fell to the floor. Why did I do this?^
          I pick up the metal rod from the floor -- it may still be useful to me.]]
      remove(s)
      return
    end
    return false
  end,
}


-- =================================================================================

room {
  nam = "loc_mainhall";
  disp = "Entrance Gate";
  dsc = [[
    The entrance gate is quiet and deserted. However, there are never many people here -- most prefer to walk through the main entrance. The former administrative building is located here. It is now rented out for office space.
  ]],
  enter = function(s, w)
    take 'personal_passcard'
  end,
  obj = {
    "mainhall_tourniquet",
    "mainhall_security",
    _"security_passcard":disable(),
    "mainhall_boxes",
    "mainhall_clock",
  },
  way = {
    path {"path_mainhall2", "Go through the turnstile", "loc_mainhall2" }:disable()
  },
}


-- =================================================================================

room {
  nam = "loc_mainhall2",
  disp = "Entrance Gate",
  noinv = true,
  enter = function(s,w)
    sound_player('snd/thunder.ogg') -- rain and thunder
    p [[It began to rain outside. There was a flash of lightning and a few seconds later, the rumble of thunder. The rain grew stronger and became a real downpour.]]
  end,
  dsc = function(s, w)
    p [[ There is no one in the lobby either. ]]
  end,
  obj = {
    obj {
      dsc = [[On the right is a {corridor}; for some reason, its lights are off.]],
      act = [[I don't want to look for the security guard to give him his ID card. I needed to get to work; I'll come back later.]]
    },
    obj {
      dsc = [[The {elevator} is to the left, and next to ]],
      act = function()
        p [[The top two floors of this building are leased by our company. The elevator door on the top floor, the fifth, had become stuck, so I needed to go to the fourth floor.]]
        enable "path_mainhall_lift"
      end
    }, 
    obj {
      dsc = [[the {stairs}.]],
      act = function()
        p [[I never liked taking the stairs up to the fourth floor. However, some cardio is always good for the body.]]
        enable "path_mainhall_stairs"
      end
    },
    obj {
      dsc = [[The entrance to the {factory floor} is straight ahead.]],
      act = [[No, I'm not going outside. I don't want to get soaked to the skin -- it's raining cats and dogs.]]
    },
  },
  way = {
    path {"path_mainhall_lift", "Elevator", 'loc_mainhall_lift'}:disable(),
    path {"path_mainhall_stairs", "Stairs", 'loc_mainhall_stairs'}:disable(),
  },
}

room {
  nam = "loc_mainhall_lift",
  disp = "Elevator",
  noinv = true,
  dsc = function (s,w)
    pn()
    if visits() > 1 then
      p[[The elevator was broken. Hoping that it would eventually turn on, I poked all the buttons once again. Alas, this did not help.]]
    else
      p [[I pushed the elevator call button. The door opened immediately and I went inside. It seems like his was not my lucky day, though. No matter which button I pressed, the elevator  was not going to take me anywhere. From somewhere above, I could hear the motor trying, but failing, to engage.
        ^
        I still had to take the stairs after all.
       ]]
    end
  end,
  way = {
    path {"lift_exit", "Exit the elevator", 'loc_mainhall2'}
  }
}

room {
  nam = "loc_mainhall_stairs",
  disp = "Stairs",
  noinv = true,
  dsc = [[
    We always used to smoke on the stairs, so the smell of tobacco never fades here. Through the windows, I can clearly see the rain pouring down all around. At such times, you’re glad that you weren’t caught out on the street.
    ^
    Frankly, the way things were going, I began to feel uneasy: alone in an empty building with a storm raging outside… Nah, it’s nothing: soon my colleagues will be here and everything will be back to normal.
  ]],
  obj = {
    obj {
      dsc = [[The {fourth floor}, at last. ]], 
      act = function()
        walk 'author_note2'
      end,
    },
  }
}



room {
  nam = "author_note2";
  disp = "From the Author";
  noinv = true;
  decor = [[
Congratulations! The first puzzle was successfully solved, but the plot has not progressed one bit. I'll try to fix this in the author's next digression :)^
So, in addition to the protagonist, the game introduces Nikolai -- the inventor of some kind of drug, the head of a secret Research Institute (I.A.G.), a positive character overall. Alas, he died long before the start of the game events.^
There is also Ruslan -- a former employee of the same Research Institute, and now a successful businessman. He manages in some not entirely above board way to find some "volunteers" to continue development of the drug. Actually, he is the main antagonist, and the game was supposed to end in a confrontation with him.^
Marina, the protagonist's girlfriend, exists only in first drafts of a plot, and she is not mentioned in the source code of the game at all. So we will assume that she does not exist.^
But who is this Anton? The question is open. In one of the plot variants, he was an ordinary student, who climbed into the abandoned building of the Research Institute and found a drug stash (this was meant to explain all the anachronisms in describing the interiors of the building). But later I gave up this idea because it complicated an already intricate plot. 
^ ^
  ]] .. fmt.c("{#next|Let's move on to a new room ... and a new puzzle.}");
  enter = function ()
    theme_switch('author')
  end
}:with {
  obj {
    nam = "#next",
    act = function()
      theme_switch('game')
      walk('loc_4f_labentrance')
    end
  }
}

