/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.syntax.english;

import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.framework.InflectedWordElement;
import simplenlg.framework.LexicalCategory;
import simplenlg.framework.ListElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.PhraseCategory;
import simplenlg.framework.PhraseElement;
import simplenlg.syntax.english.SyntaxProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PhraseHelper {
    PhraseHelper() {
    }

    static NLGElement realise(SyntaxProcessor parent, PhraseElement phrase) {
        ListElement realisedElement = null;
        if (phrase != null) {
            realisedElement = new ListElement();
            PhraseHelper.realiseList(parent, realisedElement, phrase.getPreModifiers(), DiscourseFunction.PRE_MODIFIER);
            PhraseHelper.realiseHead(parent, phrase, realisedElement);
            PhraseHelper.realiseComplements(parent, phrase, realisedElement);
            PhraseHelper.realiseList(parent, realisedElement, phrase.getPostModifiers(), DiscourseFunction.POST_MODIFIER);
        }
        return realisedElement;
    }

    private static void realiseComplements(SyntaxProcessor parent, PhraseElement phrase, ListElement realisedElement) {
        boolean firstProcessed = false;
        NLGElement currentElement = null;
        for (NLGElement complement : phrase.getFeatureAsElementList("complements")) {
            currentElement = parent.realise(complement);
            if (currentElement == null) continue;
            currentElement.setFeature("discourse_function", (Object)DiscourseFunction.COMPLEMENT);
            if (firstProcessed) {
                realisedElement.addComponent(new InflectedWordElement("and", LexicalCategory.CONJUNCTION));
            } else {
                firstProcessed = true;
            }
            realisedElement.addComponent(currentElement);
        }
    }

    private static void realiseHead(SyntaxProcessor parent, PhraseElement phrase, ListElement realisedElement) {
        NLGElement head = phrase.getHead();
        if (head != null) {
            if (phrase.hasFeature("is_comparative")) {
                head.setFeature("is_comparative", phrase.getFeature("is_comparative"));
            } else if (phrase.hasFeature("is_superlative")) {
                head.setFeature("is_superlative", phrase.getFeature("is_superlative"));
            }
            head = parent.realise(head);
            head.setFeature("discourse_function", (Object)DiscourseFunction.HEAD);
            realisedElement.addComponent(head);
        }
    }

    static void realiseList(SyntaxProcessor parent, ListElement realisedElement, List<NLGElement> elementList, DiscourseFunction function) {
        ListElement realisedList = new ListElement();
        NLGElement currentElement = null;
        for (NLGElement eachElement : elementList) {
            currentElement = parent.realise(eachElement);
            if (currentElement == null) continue;
            currentElement.setFeature("discourse_function", (Object)function);
            if (eachElement.getFeatureAsBoolean("appositive").booleanValue()) {
                currentElement.setFeature("appositive", true);
            }
            realisedList.addComponent(currentElement);
        }
        if (!realisedList.getChildren().isEmpty()) {
            realisedElement.addComponent(realisedList);
        }
    }

    public static boolean isExpletiveSubject(PhraseElement phrase) {
        List<NLGElement> subjects = phrase.getFeatureAsElementList("subjects");
        boolean expletive = false;
        if (subjects.size() == 1) {
            NLGElement subjectNP = subjects.get(0);
            if (subjectNP.isA(PhraseCategory.NOUN_PHRASE)) {
                expletive = subjectNP.getFeatureAsBoolean("expletive_subject");
            } else if (subjectNP.isA(PhraseCategory.CANNED_TEXT)) {
                expletive = "there".equalsIgnoreCase(subjectNP.getRealisation());
            }
        }
        return expletive;
    }
}

