/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexAccess.Api;

import gov.nih.nlm.nls.lexAccess.Util.GlobalVars;
import gov.nih.nlm.nls.lexCheck.Api.ToJavaObjApi;
import gov.nih.nlm.nls.lexCheck.Lib.InflVar;
import gov.nih.nlm.nls.lexCheck.Lib.LexRecord;
import java.util.Vector;

public class LexAccessApiResult {
    private String text_ = new String();
    private Vector<LexRecord> lexRecordObjs_ = new Vector();

    public void SetJavaObjs(Vector<LexRecord> lexReocrdObjs) {
        this.lexRecordObjs_ = lexReocrdObjs;
        this.text_ = new String();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                this.text_ = this.text_ + temp.GetText();
            }
        }
    }

    public void SetText(String text) {
        this.text_ = text;
        try {
            this.lexRecordObjs_ = ToJavaObjApi.ToJavaObjsFromText(text);
        }
        catch (Exception e) {
            System.out.println("** Error: " + e.getMessage());
        }
    }

    public String GetText() {
        return this.text_;
    }

    public Vector<LexRecord> GetJavaObjs() {
        return this.lexRecordObjs_;
    }

    public String GetXml() {
        StringBuffer xmlOut = new StringBuffer();
        if (this.lexRecordObjs_ != null) {
            xmlOut.append(LexRecord.GetXmlHeader());
            xmlOut.append(GlobalVars.LS_STR);
            xmlOut.append(LexRecord.GetXmlRootBeginTag());
            xmlOut.append(GlobalVars.LS_STR);
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                xmlOut.append(temp.GetXml(1));
            }
            xmlOut.append(LexRecord.GetXmlRootEndTag());
            xmlOut.append(GlobalVars.LS_STR);
        }
        return xmlOut.toString();
    }

    public Vector<String> GetBases() {
        Vector<String> bases = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                bases.addElement(temp.GetBase());
            }
        }
        return bases;
    }

    public Vector<String> GetBases(String separator) {
        Vector<String> bases = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                bases.addElement(temp.GetBase() + separator + temp.GetEui() + separator + temp.GetCategory());
            }
        }
        return bases;
    }

    public Vector<String> GetSpellingVars() {
        Vector<String> spellingVars = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                spellingVars.addElement(temp.GetBase());
                spellingVars.addAll(temp.GetSpellingVars());
            }
        }
        return spellingVars;
    }

    public Vector<String> GetSpellingVars(String separator) {
        Vector<String> spellingVars = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                String eui = temp.GetEui();
                String category = temp.GetCategory();
                spellingVars.addElement(temp.GetBase() + separator + eui + separator + category);
                Vector<String> tempSpellVars = temp.GetSpellingVars();
                for (int j = 0; j < tempSpellVars.size(); ++j) {
                    String tempSpellVar = tempSpellVars.elementAt(j);
                    spellingVars.addElement(tempSpellVar + separator + eui + separator + category);
                }
            }
        }
        return spellingVars;
    }

    public Vector<String> GetInflVars() {
        Vector<String> inflVars = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                Vector<InflVar> inflValues = temp.GetInflVarsAndAgreements().GetInflValues();
                for (int j = 0; j < inflValues.size(); ++j) {
                    InflVar inflVar = inflValues.elementAt(j);
                    inflVars.addElement(inflVar.GetVar());
                }
            }
        }
        return inflVars;
    }

    public Vector<String> GetInflVars(String separator) {
        Vector<String> inflVars = new Vector<String>();
        if (this.lexRecordObjs_ != null) {
            for (int i = 0; i < this.lexRecordObjs_.size(); ++i) {
                LexRecord temp = this.lexRecordObjs_.elementAt(i);
                Vector<InflVar> inflValues = temp.GetInflVarsAndAgreements().GetInflValues();
                for (int j = 0; j < inflValues.size(); ++j) {
                    InflVar inflVar = inflValues.elementAt(j);
                    String inflVarDetail = inflVar.GetVar() + separator + inflVar.GetCat() + separator + inflVar.GetInflection() + separator + inflVar.GetEui() + separator + inflVar.GetUnInfl() + separator + inflVar.GetCit() + separator + inflVar.GetType();
                    inflVars.addElement(inflVarDetail);
                }
            }
        }
        return inflVars;
    }

    public int GetTotalRecordNumber() {
        return this.lexRecordObjs_.size();
    }
}

