/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.builds;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleNounPhrase;
import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.goability.DefaultGoHandler;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.takeable.ProducesComponentsTakeHandler;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import java.util.List;
import java.util.Set;

public class Shelters
extends Dsl {
    public Shelters(Simulation simulation) {
        super(simulation);
    }

    public Noun leanToShelter(AdjectivePhrase adjective, List<Noun> resources, Noun spot) {
        String _adjective_ = adjective == null ? " " : " " + adjective + " ";
        NounPhrase verticalStructureNp = resources.get(0).getContextFreeDescription();
        Noun beamStructure = resources.get(1);
        NounPhrase beamStructureNp = beamStructure.getContextFreeDescription();
        Noun roofMaterial = resources.get(2);
        NounPhrase roofMaterialNp = roofMaterial.getContextFreeDescription();
        SimpleNounPhrase.Builder descrBuilder = SimpleNounPhrase.builder().setSingular("shelter").setPlural("shelters");
        if (adjective != null) {
            descrBuilder.addAdjective(adjective);
        }
        descrBuilder.addAdjective(Nlg.pureAdjective("lean-to"));
        descrBuilder.addAlternativeMatchableNounPhrase(Nlg.autoNounPhrase("a" + _adjective_ + "lean-to"));
        SimpleNounPhrase nounPhraseDescription = descrBuilder.build();
        Sentences verboseDescr = Nlg.literalClauseSentence(NounPhraseWithArticle.a(beamStructureNp) + " is propped up against " + NounPhraseWithArticle.a(verticalStructureNp) + " and covered with " + NounPhraseWithArticle.a(roofMaterialNp) + " to form " + NounPhraseWithArticle.a(nounPhraseDescription));
        SimpleNoun outside = SimpleNoun.autoBuilder().setDescription(verboseDescr, nounPhraseDescription).setDarkDescription("This lean-to shelter is barely visible in the dark.", "a barely visible lean-to shelter", "shelters", "a lean-to", "lean-tos").build();
        Sentences insideVerboseDescr = Nlg.literalClauseSentence("you can barely move in this cramped lean-to but at least " + NounPhraseWithArticle.the(roofMaterialNp) + " overhead provide some shelter from the elements");
        SimpleNoun inside = SimpleNoun.autoBuilder().setDescription(insideVerboseDescr, nounPhraseDescription).alwaysVisible().build();
        if (spot != null) {
            this.createExit(inside, SpacialRelationship.of(Prepositions.out), spot);
        }
        Noun entrance = this.assembleInsideOutsideGetEntrance(inside, Prepositions.in, outside);
        this.makeProvideMaxShade(entrance);
        this.makeBlockRain(entrance);
        this.setTakeHandler(outside, new ProducesComponentsTakeHandler(beamStructure, roofMaterial));
        this.addResourceCapability(outside, ResourceCapabilities.SMALL_BURNABLE_MATERIAL);
        return outside;
    }

    public Noun assembleInsideOutsideGetEntrance(Noun inside, Preposition preposition, Noun outside) {
        this.makeSurrounding(preposition, inside);
        this.makeExternallyInvisible(inside);
        this.put(inside, preposition, outside);
        this.makeIntegral(inside);
        EmptyNoun entrance = new EmptyNoun();
        this.createEntrance(outside, SpacialRelationship.of(preposition), (Noun)entrance);
        this.makeGoToSpot(outside, SpacialRelationship.of(preposition), inside);
        this.createEntrance(inside, SpacialRelationship.of(preposition), inside);
        this.setGoHandler(inside, preposition, (GoHandler)new DefaultGoHandler(){

            @Override
            public void handleGo(Noun goer, SpacialRelationship spacialRelationship, SpacialRelationship reverseSpacialRelationship, Simulation simulation, PositionStateBuilder partialState, Noun place) {
                Set<Noun> childrenOfPlace = PositionState.get(simulation.getCurrentFrame()).getChildren(place);
                if (childrenOfPlace != null && childrenOfPlace.contains(goer)) {
                    PlayerNotificationEvent.post(goer, simulation, "You are already in " + NounPhraseWithArticle.the(place.getContextFreeDescription()) + ".");
                } else {
                    super.handleGo(goer, spacialRelationship, reverseSpacialRelationship, simulation, partialState, place);
                }
            }
        });
        return entrance;
    }
}

