/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.tools.lumberjack;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.capability.ToolState;
import com.fabriziopolo.textcraft.states.light.LightState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.DefaultTakeHandler;
import com.fabriziopolo.timecraft.capabilities.ToolCapabilities;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TreeCuttingTakeHandler
extends DefaultTakeHandler {
    private final List<Noun> produce;

    public TreeCuttingTakeHandler(Noun produce) {
        this.produce = new ArrayList<Noun>();
        this.produce.add(produce);
    }

    public TreeCuttingTakeHandler(List<Noun> produce) {
        this.produce = produce;
    }

    @Override
    public boolean isProducible(Player player, Noun nounToTake, Noun tool, Frame frame) {
        PositionState positions = PositionState.get(frame);
        if (LightState.getBrightnessAt(nounToTake, frame) <= 0.2) {
            return false;
        }
        return !this.isPlayerInTree(player, nounToTake, frame, positions) && this.getDisallowedNonPlayerContentsOfTree(player, nounToTake, frame, positions).isEmpty() && ToolState.toolSatisfiesCapability(tool, ToolCapabilities.TREE_CUTTING, frame);
    }

    @Override
    public void onNotProducible(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        NounPhrase nounPerception = nounToTake.getDefaultPerception(frame);
        if (LightState.getBrightnessAt(nounToTake, frame) <= 0.2) {
            PlayerNotificationEvent.post((Noun)player, simulation, "It is too dark to cut down " + NounPhraseWithArticle.a(nounPerception) + ".");
            return;
        }
        if (this.isPlayerInTree(player, nounToTake, frame, partialState)) {
            Preposition preposition = partialState.getPreposition(player, nounToTake);
            if (preposition == null) {
                PlayerNotificationEvent.post((Noun)player, simulation, "You have to get out of " + NounPhraseWithArticle.the(nounPerception) + " first.");
            } else {
                PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(nounPerception) + " while you are " + preposition + " it.");
            }
        }
        Set<Noun> contents = this.getDisallowedNonPlayerContentsOfTree(player, nounToTake, frame, partialState);
        PositionState positionState = PositionState.get(frame);
        for (Noun content : contents) {
            NounPhrase contentPerception = content.getDefaultPerception(frame);
            Preposition preposition = positionState.getPreposition(content, nounToTake);
            if (preposition != null) {
                PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(nounPerception) + " while it still has " + NounPhraseWithArticle.a(contentPerception) + " " + preposition + " it.");
                continue;
            }
            PlayerNotificationEvent.post((Noun)player, simulation, "You must remove " + NounPhraseWithArticle.the(contentPerception) + " first.");
        }
        if (!ToolState.toolSatisfiesCapability(tool, ToolCapabilities.TREE_CUTTING, frame)) {
            PlayerNotificationEvent.post((Noun)player, simulation, "You cannot take " + NounPhraseWithArticle.the(nounPerception) + " without a suitable cutting tool.");
        }
    }

    @Override
    public List<Noun> willProduce(Player player, Noun nounToTake, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        return new ArrayList<Noun>(this.produce);
    }

    @Override
    public void doProduce(Player player, Noun originalNounToTake, List<Noun> producedNouns, Noun tool, Simulation simulation, PositionStateBuilder partialState) {
        Frame frame = simulation.getCurrentFrame();
        NounPhrase nounPerception = originalNounToTake.getDefaultPerception(frame);
        NounPhrase toolPerception = tool.getDefaultPerception(frame);
        PlayerNotificationEvent.post((Noun)player, simulation, "You fell " + NounPhraseWithArticle.the(nounPerception) + " with " + NounPhraseWithArticle.a(toolPerception) + ".");
        partialState.disconnect(originalNounToTake);
    }

    private boolean isPlayerInTree(Player player, Noun nounToTake, Frame frame, PositionState partialState) {
        List<Noun> nonintegralDescendents = StructureState.getNonintegralDescendents(nounToTake, frame, partialState);
        return nonintegralDescendents.contains(player);
    }

    private Set<Noun> getDisallowedNonPlayerContentsOfTree(Player player, Noun nounToTake, Frame frame, PositionState partialState) {
        Set<Noun> nonintegralChildren = StructureState.getNonintegralChildren(nounToTake, frame, partialState);
        Set<Noun> disallowedNouns = nonintegralChildren.stream().filter(noun -> noun.getContextFreeDescription().toString().contains("lean-to")).collect(Collectors.toSet());
        return disallowedNouns;
    }
}

