/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.text;

import com.fabriziopolo.textcraft.text.Text;
import java.util.ArrayList;
import java.util.List;

public class DebugInfoBuilder {
    private final Class stateClass;
    private final List<String> lines = new ArrayList<String>();

    public DebugInfoBuilder(Class stateClass) {
        this.stateClass = stateClass;
    }

    public void addLine(String label, Object value) {
        if (value == null) {
            return;
        }
        this.lines.add(label + ": " + value.toString());
    }

    public String toString() {
        if (this.lines.size() == 0) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String entryName = this.stateClass.getSimpleName();
        if (entryName.length() >= 5) {
            entryName = entryName.substring(0, entryName.length() - 5);
        }
        builder.append(entryName);
        if (this.lines.size() == 1) {
            builder.append(" - " + this.lines.get(0));
            builder.append(Text.getLineSeparator());
        } else {
            builder.append(" - ");
            builder.append(Text.getLineSeparator());
            this.lines.forEach(line -> {
                builder.append("  " + line);
                builder.append(Text.getLineSeparator());
            });
        }
        return builder.toString();
    }
}

