/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.temperature;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.position.AbstractPathAlgorithm;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.temperature.FlexibleHeatUnit;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilter;
import java.util.Objects;

public class TemperatureFilterState
extends ValueState<TemperatureFilter> {
    @Override
    protected Class getStateKey() {
        return TemperatureFilterState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        TemperatureFilterState newState = new TemperatureFilterState();
        this.setUpdatedState(simulation, newState);
        newState.setImmutable();
        return newState;
    }

    public TemperatureFilter getFilter(Noun noun) {
        return (TemperatureFilter)this.get(noun);
    }

    public static TemperatureFilterState get(Frame frame) {
        return (TemperatureFilterState)frame.states.get(TemperatureFilterState.class);
    }

    public static void requestSetTemperatureFilter(Noun noun, TemperatureFilter filter, Simulation simulation) {
        simulation.requestStateChange(TemperatureFilterState.class, new ValueState.ChangeRequest<TemperatureFilter>(noun, filter));
    }

    public static FlexibleHeatUnit getTemperatureFilteredAcrossPath(Noun target, Noun source, FlexibleHeatUnit heat, Frame frame) {
        return TemperatureFilterPathAlgorithm.getTemperatureFilteredAcrossPath(target, source, heat, frame);
    }

    public static FlexibleHeatUnit getTemperatureFilteredFromOutside(Noun target, FlexibleHeatUnit heat, Frame frame) {
        return TemperatureFilterPathAlgorithm.getTemperatureFilteredFromOutside(target, heat, frame);
    }

    public static void requestSetTemperatureFilter(Noun noun, final FlexibleHeatUnit deltaHeat, Simulation simulation) {
        simulation.requestStateChange(TemperatureFilterState.class, new ValueState.ChangeRequest<1>(noun, new TemperatureFilter(){

            @Override
            public FlexibleHeatUnit applyFilter(FlexibleHeatUnit heat, Frame frame) {
                return heat.plus(deltaHeat);
            }

            public String toString() {
                return "Plus(" + deltaHeat.toString() + ")";
            }
        }));
    }

    private static final class TemperatureFilterPathAlgorithm
    extends AbstractPathAlgorithm {
        private FlexibleHeatUnit heat;

        private TemperatureFilterPathAlgorithm(FlexibleHeatUnit heat) {
            this.heat = Objects.requireNonNull(heat);
        }

        public static FlexibleHeatUnit getTemperatureFilteredAcrossPath(Noun target, Noun source, FlexibleHeatUnit heat, Frame frame) {
            TemperatureFilterPathAlgorithm algorithm = new TemperatureFilterPathAlgorithm(heat);
            algorithm.traversePathBetween(source, target, frame);
            return algorithm.heat;
        }

        public static FlexibleHeatUnit getTemperatureFilteredFromOutside(Noun target, FlexibleHeatUnit heat, Frame frame) {
            TemperatureFilterPathAlgorithm algorithm = new TemperatureFilterPathAlgorithm(heat);
            algorithm.traversePathFromExterior(target, frame);
            return algorithm.heat;
        }

        @Override
        protected boolean onInternalNoun(Noun noun, PathSegment segment, Frame frame) {
            TemperatureFilter filter = (TemperatureFilter)TemperatureFilterState.get(frame).get(noun);
            if (filter == null) {
                return true;
            }
            this.heat = filter.applyFilter(this.heat, frame);
            return true;
        }
    }
}

