/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.position.updates;

import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.PositionUpdateRequest;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.TakeHandler;
import com.fabriziopolo.textcraft.states.takeable.TakeableState;
import com.fabriziopolo.textcraft.states.takeable.UntakeableTakeHandler;

public class TakeObjectsPositionUpdateRequest
implements PositionUpdateRequest {
    private static final TakeHandler DEFAULT_TAKE_HANDLER = new TakeHandler(){};
    public final Player player;
    public final Noun object;
    public final Noun tool;

    private TakeObjectsPositionUpdateRequest(Player player, Noun object, Noun tool) {
        this.player = player;
        this.object = object;
        this.tool = tool;
    }

    @Override
    public void apply(PositionStateBuilder partialState, Simulation simulation) {
        Frame currentFrame = simulation.getCurrentFrame();
        TakeHandler takeHandler = this.getTakeHandler(currentFrame);
        takeHandler.handleTake(this.player, this.object, this.tool, simulation, partialState);
    }

    private TakeHandler getTakeHandler(Frame frame) {
        TakeHandler takeHandler = TakeableState.get(frame).get(this.object);
        if (takeHandler == null) {
            takeHandler = StructureState.get(frame).isIntegral(this.object) ? this.getDefaultUntakeableTakeHandler(frame) : DEFAULT_TAKE_HANDLER;
        }
        return takeHandler;
    }

    private TakeHandler getDefaultUntakeableTakeHandler(Frame frame) {
        return UntakeableTakeHandler.withMessage("You can't take that.  It's part of " + NounPhraseWithArticle.a(this.player.getPerceptionOf(PositionState.get(frame).getParent(this.object), frame)) + ".");
    }

    public static void post(Player player, Noun objectToTake, Noun tool, Simulation simulation) {
        simulation.requestStateChange(PositionState.class, new TakeObjectsPositionUpdateRequest(player, objectToTake, tool));
    }
}

