/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.edibility;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.PureIndependentClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.edibility.EatHandler;
import com.fabriziopolo.textcraft.states.edibility.EdibleEffect;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;

public class DefaultEatHandler
implements EatHandler {
    public EdibleEffect getEffect(Noun eatenObject, Frame frame) {
        return null;
    }

    public void removeConsumed(Perceiver consumer, Noun consumed, Simulation simulation) {
        InventoryState.requestRemoveItem(consumer, consumed, simulation);
        PositionState.requestRemove(consumed, simulation);
    }

    public Noun getObjectToEat(Noun objectToEat, Frame frame) {
        return objectToEat;
    }

    public void onNoObjectToEat(Perceiver consumer, Noun objectToEat, Simulation simulation) {
        PlayerNotificationEvent.postAlwaysPerceivable(consumer, "That isn't edible.", simulation);
    }

    @Override
    public void handleEat(Perceiver consumer, Noun objectToEat, String consumptionVerb, String pastTenseOfConsumptionVerb, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        Noun actualObjectToEat = this.getObjectToEat(objectToEat, frame);
        if (actualObjectToEat == null) {
            this.onNoObjectToEat(consumer, objectToEat, simulation);
            return;
        }
        String youEatTheThingPlayerMessage = "you " + consumptionVerb + " " + NounPhraseWithArticle.the(consumer.getPerceptionOf(actualObjectToEat, frame));
        PlayerNotificationEvent.postAlwaysPerceivable(consumer, Nlg.literalClauseSentence(youEatTheThingPlayerMessage).toString(), simulation);
        String youEatTheThingCause = "you " + pastTenseOfConsumptionVerb + " " + NounPhraseWithArticle.the(consumer.getPerceptionOf(actualObjectToEat, frame));
        EdibleEffect effect = this.getEffect(actualObjectToEat, frame);
        if (effect != null) {
            effect.onConsumption(simulation, consumer, actualObjectToEat, new PureIndependentClause(youEatTheThingCause));
        }
        this.removeConsumed(consumer, actualObjectToEat, simulation);
    }
}

