/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.capability;

import com.fabriziopolo.textcraft.nlg.Conjunctions;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.IndependentClausesWithConjunction;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import java.io.Serializable;
import java.util.ArrayList;

public interface Capability
extends Serializable {
    default public Result isSatisfiedBy(Noun noun, Capability tool, Frame frame) {
        return Result.create(tool.getClass().isAssignableFrom(this.getClass()));
    }

    public String getNounDescription();

    default public Capability or(final Capability otherCapability) {
        return new Capability(){

            @Override
            public Result isSatisfiedBy(Noun noun, Capability tool, Frame frame) {
                return Capability.this.isSatisfiedBy(noun, tool, frame).or(otherCapability.isSatisfiedBy(noun, tool, frame));
            }

            @Override
            public String getNounDescription() {
                return Capability.this.getNounDescription() + " or " + otherCapability.getNounDescription();
            }
        };
    }

    public static class Result {
        public final boolean isSatisfied;
        public final IndependentClause failureReason;

        private Result(boolean isSatisfied, IndependentClause failureReason) {
            this.isSatisfied = isSatisfied;
            this.failureReason = failureReason;
        }

        public static Result createSuccess() {
            return new Result(true, null);
        }

        public static Result createFailure() {
            return new Result(false, null);
        }

        public static Result createFailure(IndependentClause reason) {
            return new Result(false, reason);
        }

        public static Result createFailure(String reason) {
            return new Result(false, Nlg.literalClause(reason));
        }

        public static Result create(boolean result) {
            return new Result(result, null);
        }

        public Result or(Result otherResult) {
            if (this.isSatisfied) {
                return this;
            }
            if (otherResult.isSatisfied) {
                return otherResult;
            }
            ArrayList<IndependentClause> clauses = new ArrayList<IndependentClause>();
            if (this.failureReason != null) {
                clauses.add(this.failureReason);
            }
            if (otherResult.failureReason != null) {
                clauses.add(otherResult.failureReason);
            }
            if (clauses.isEmpty()) {
                return Result.createFailure();
            }
            return Result.createFailure(new IndependentClausesWithConjunction(clauses, Conjunctions.and));
        }
    }
}

