/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.position;

import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.constants.Directions;
import com.fabriziopolo.textcraft.states.description.DescriptionState;
import com.fabriziopolo.textcraft.states.position.PathSegment;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.room.RoomState;
import com.fabriziopolo.textcraft.states.scenery.SceneryState;

public class PlayerLooksInDirectionEvent
implements Event {
    private final Noun direction;
    private final Perceiver player;

    private PlayerLooksInDirectionEvent(Noun direction, Perceiver player) {
        this.direction = direction;
        this.player = player;
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        if (perceiver != this.player) {
            return null;
        }
        PositionState positionState = PositionState.get(frame);
        Noun currentRoom = positionState.getContainingRoom(perceiver);
        PathSegment pathSegment = PositionState.get(frame).getExit(currentRoom, SpacialRelationship.of(this.direction));
        DescriptionState descriptionState = DescriptionState.get(frame);
        Sentences exitDescriptionSentences = null;
        if (pathSegment == null) {
            exitDescriptionSentences = this.handleNoExit(perceiver, channel, frame);
        } else {
            NounPhrase exitDescription = descriptionState.getPathSegmentAsPerceivedBy(perceiver, pathSegment, frame);
            exitDescriptionSentences = Nlg.literalSentences("To the " + perceiver.getPerceptionOf(this.direction, frame) + " is " + NounPhraseWithArticle.a(exitDescription) + ".");
        }
        Sentences sceneryDescriptionSentences = SceneryState.getSceneryDescription(perceiver, this.direction, frame);
        return MultipleSentences.builder().add(exitDescriptionSentences).add(sceneryDescriptionSentences).build();
    }

    private Sentences handleNoExit(Perceiver perceiver, PerceptionChannel channel, Frame frame) {
        Noun room = PositionState.get(frame).getContainingRoom(perceiver);
        if (room == null) {
            return null;
        }
        if (this.direction.equals(Directions.get((Frame)frame).down)) {
            Noun floor = RoomState.get(frame).getFloor(room);
            return this.player.getVerbosePerceptionOf(floor, frame);
        }
        if (this.direction.equals(Directions.get((Frame)frame).up)) {
            return DescriptionState.getVerboseDescriptionOfWeather(perceiver, frame);
        }
        return null;
    }

    public static void post(Noun direction, Player player, Simulation simulation) {
        simulation.postEvent(new PlayerLooksInDirectionEvent(direction, player));
    }

    public static void post(Noun direction, Command.Context context) {
        context.simulation.postEvent(new PlayerLooksInDirectionEvent(direction, context.player));
    }
}

