/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.inventory;

import com.fabriziopolo.textcraft.nlg.GroupedCollectionNounPhrase;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Person;
import com.fabriziopolo.textcraft.nlg.Pronouns;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.VerbPhrase;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.wearabililty.WearableCategory;
import com.fabriziopolo.textcraft.text.BarNumberRenderer;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PlayerExaminesInventoryEvent
implements Event {
    private static final VerbPhrase have = Nlg.pureVerb("have", "have", "has", "have").as(Person.SecondPerson, Number.Singular);
    private final Noun player;

    public PlayerExaminesInventoryEvent(Noun player) {
        this.player = player;
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        ArrayList wornItems;
        InventoryState inventoryState = InventoryState.get(frame);
        Inventory inventory = inventoryState.get(this.player);
        Noun wieldedItemOrNull = inventoryState.getWieldedItem(this.player);
        Map<WearableCategory, Noun> wornItemsMap = InventoryState.getWornItemsMap(this.player, frame);
        ArrayList arrayList = wornItems = wornItemsMap != null ? wornItemsMap.values() : new ArrayList();
        if (inventory == null || inventory.getItems().size() == 0) {
            return Nlg.literalSentences("You have nothing.");
        }
        List<Noun> items = inventory.getItems();
        if (wieldedItemOrNull != null) {
            items.remove(wieldedItemOrNull);
        }
        if (wornItems != null) {
            items.removeAll(wornItems);
        }
        List nounPhrases = items.stream().map(item -> item.getDefaultPerception(frame)).collect(Collectors.toList());
        MultipleSentences.Builder builder = MultipleSentences.builder();
        String encumbranceBar = new BarNumberRenderer().render(InventoryState.getEncumbrance(this.player, frame) / Encumbrances.MAX, 1.0);
        builder.add(Nlg.literalSentences("Encumbrance - " + encumbranceBar + Text.getLineSeparator()));
        if (!items.isEmpty()) {
            Sentences allItemsDescription = Nlg.simpleSentence(Pronouns.You, have, GroupedCollectionNounPhrase.create(nounPhrases));
            builder.add(allItemsDescription);
        }
        if (wornItems != null && !wornItems.isEmpty()) {
            List wornItemDescriptions = wornItems.stream().map(item -> item.getDefaultPerception(frame)).collect(Collectors.toList());
            builder.add(Nlg.literalClauseSentence("you are wearing " + NounPhraseWithArticle.a(GroupedCollectionNounPhrase.create(wornItemDescriptions))));
        }
        if (wieldedItemOrNull != null) {
            builder.add(Nlg.literalClauseSentence("you wield " + NounPhraseWithArticle.a(wieldedItemOrNull.getDefaultPerception(frame))));
        }
        return builder.build();
    }
}

