/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.states.inventory.UnwieldRequest;

public class UnwieldCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length == 0) {
            return null;
        }
        String commandWord = words[0].toLowerCase();
        if (!commandWord.equals("unwield")) {
            return null;
        }
        if (words.length > 1) {
            return ActionsAndHints.hint(this.getHelpString());
        }
        return ActionsAndHints.action(new Result(context));
    }

    @Override
    public String getHelpString() {
        return "Type 'unwield' to stop wielding whatever item you're currently using.";
    }

    @Override
    public String getNameString() {
        return "unwield";
    }

    @Override
    public String getPurposeString() {
        return "Stop wielding an item.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static final class Result
    implements UserAction {
        private final Command.Context context;

        public Result(Command.Context context) {
            this.context = context;
        }

        @Override
        public String getDescription() {
            return "to unwield the currently wielded item";
        }

        @Override
        public void execute(TextAppController controller) {
            UnwieldRequest.request(this.context.player, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return true;
        }
    }
}

