/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.AbstractCommandWithTool;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.updates.TakeObjectsPositionUpdateRequest;
import com.fabriziopolo.textcraft.text.Text;
import com.fabriziopolo.textcraft.text.TextMatcher;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class TakeCommand
extends AbstractCommandWithTool {
    private static final List<String> TAKE_SYNONYMS = Arrays.asList("take", "t", "get", "grab");

    @Override
    public ActionsAndHints parseWithTool(String[] words, Command.Context context, Noun tool) {
        if (words.length < 1) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (!TAKE_SYNONYMS.contains(firstWord)) {
            return null;
        }
        if (words.length == 1) {
            return this.failWithHint();
        }
        Frame frame = context.simulation.getCurrentFrame();
        List<TextMatcher.ResultWithData<Noun>> results = TakeCommand.matchOneAccessibleNoun(words, 1, context.player, frame);
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result(context, (Noun)tmResult.data, tool)).collect(Collectors.toList()));
    }

    public static List<TextMatcher.ResultWithData<Noun>> matchOneAccessibleNoun(String[] words, int startIdx, Player player, Frame frame) {
        List<Noun> nounsWeMightTake = TakeCommand.getAccessibleNouns(player, frame);
        return AbstractCommand.matchOne(words, startIdx, nounsWeMightTake, player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).collect(Collectors.toList());
    }

    private ActionsAndHints failWithHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to take.");
    }

    @Override
    public String getHelpString() {
        return "To take something, type 'take' followed by the object you want to take (e.g. 'take banana').  To take some things you may need a tool or container.  Either wield the tool/container or add a 'with clause' (e.g. 'take oil with can').";
    }

    @Override
    public String getNameString() {
        return "take";
    }

    @Override
    public String getPurposeString() {
        return "Take an object and add it to your inventory. (t)";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    public static List<Noun> getAccessibleNouns(Perceiver player, Frame frame) {
        List<Noun> perceivableNouns = player.getPerceivableNouns(frame).stream().filter(noun -> !InventoryState.isInInventory(player, noun, frame)).collect(Collectors.toList());
        return Text.chooseRepresentativesByDescription(perceivableNouns, player, frame);
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun objectToTake;
        private final Noun tool;

        private Result(Command.Context context, Noun objectToTake, Noun tool) {
            this.context = context;
            this.objectToTake = objectToTake;
            this.tool = tool;
        }

        @Override
        public String getDescription() {
            return "to take " + NounPhraseWithArticle.the(this.context.player.getPerceptionOf(this.objectToTake, this.context.simulation.getCurrentFrame()));
        }

        @Override
        public void execute(TextAppController controller) {
            TakeObjectsPositionUpdateRequest.post(this.context.player, this.objectToTake, this.tool, this.context.simulation);
        }

        @Override
        public boolean isValid(Frame frame) {
            return TakeCommand.getAccessibleNouns(this.context.player, frame).contains(this.objectToTake);
        }
    }
}

