/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.commands;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.commands.AbstractCommand;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.states.inventory.Inventory;
import com.fabriziopolo.textcraft.states.inventory.InventoryRemoveItemsRequest;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.updates.DropObjectPositionUpdateRequest;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.text.Text;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DropCommand
implements Command {
    @Override
    public ActionsAndHints parse(String[] words, Command.Context context) {
        if (words.length < 1) {
            return null;
        }
        String firstWord = words[0].toLowerCase();
        if (!firstWord.equals("drop")) {
            return null;
        }
        if (words.length == 1) {
            return this.failWithHint();
        }
        Frame frame = context.simulation.getCurrentFrame();
        List<Noun> nounsWeMightTake = this.getAccessibleNouns(context.player, frame);
        List results = AbstractCommand.matchOne(words, 1, nounsWeMightTake, context.player, frame).stream().filter(result -> result.getStartIndex() + result.getNumWordsMatched() == words.length).collect(Collectors.toList());
        if (results.isEmpty()) {
            return this.failWithBadObjectHint();
        }
        return new ActionsAndHints(results.stream().map(tmResult -> new Result(context, (Noun)tmResult.data)).collect(Collectors.toList()));
    }

    private ActionsAndHints failWithHint() {
        return ActionsAndHints.hint(this.getHelpString());
    }

    private ActionsAndHints failWithBadObjectHint() {
        return ActionsAndHints.hint("I don't recognize the item you're trying to drop.");
    }

    @Override
    public String getHelpString() {
        return "Type 'drop' followed by the name of an item in your inventory to drop that item on the ground.";
    }

    @Override
    public String getNameString() {
        return "drop";
    }

    @Override
    public String getPurposeString() {
        return "Remove an item from your inventory and leave it on the ground.";
    }

    @Override
    public boolean isVisibleInHelp() {
        return true;
    }

    private List<Noun> getAccessibleNouns(Player player, Frame frame) {
        Inventory inventory = InventoryState.get(frame).get(player);
        if (inventory == null) {
            return new ArrayList<Noun>();
        }
        List<Noun> inventoryItems = inventory.getItems();
        ArrayList<Noun> items = new ArrayList<Noun>();
        items.addAll(inventoryItems);
        inventoryItems.forEach(item -> items.addAll(StructureState.getNonintegralChildren(item, frame)));
        return Text.chooseRepresentativesByDescription(items, player, frame);
    }

    class Result
    implements UserAction {
        private final Command.Context context;
        private final Noun objectToDrop;

        private Result(Command.Context context, Noun objectToDrop) {
            this.context = context;
            this.objectToDrop = objectToDrop;
        }

        @Override
        public String getDescription() {
            return "to drop " + NounPhraseWithArticle.the(this.getPerceptionOfObjectToDrop());
        }

        private NounPhrase getPerceptionOfObjectToDrop() {
            return this.context.player.getPerceptionOf(this.objectToDrop, this.context.simulation.getCurrentFrame());
        }

        @Override
        public void execute(TextAppController controller) {
            PlayerNotificationEvent.postAlwaysPerceivable("You drop " + NounPhraseWithArticle.the(this.getPerceptionOfObjectToDrop()) + ".", this.context);
            InventoryRemoveItemsRequest.post(this.objectToDrop, this.context);
            DropObjectPositionUpdateRequest.post(this.objectToDrop, this.context);
        }

        @Override
        public boolean isValid(Frame frame) {
            return DropCommand.this.getAccessibleNouns(this.context.player, frame).contains(this.objectToDrop);
        }
    }
}

