/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.aggregation;

import java.util.ArrayList;
import java.util.List;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AggregationRule {
    protected NLGFactory factory = new NLGFactory();

    public void setFactory(NLGFactory factory) {
        this.factory = factory;
    }

    public NLGFactory getFactory() {
        return this.factory;
    }

    public List<NLGElement> apply(List<NLGElement> phrases) {
        ArrayList<NLGElement> results = new ArrayList<NLGElement>();
        if (phrases.size() >= 2) {
            ArrayList<NLGElement> removed = new ArrayList<NLGElement>();
            for (int i = 0; i < phrases.size(); ++i) {
                NLGElement current = phrases.get(i);
                if (removed.contains(current)) continue;
                for (int j = i + 1; j < phrases.size(); ++j) {
                    NLGElement next = phrases.get(j);
                    NLGElement aggregated = this.apply(current, next);
                    if (aggregated == null) continue;
                    current = aggregated;
                    removed.add(next);
                }
                results.add(current);
            }
        } else if (phrases.size() == 1) {
            results.add(this.apply(phrases.get(0)));
        }
        return results;
    }

    public NLGElement apply(NLGElement phrase) {
        NLGElement result = null;
        if (phrase instanceof CoordinatedPhraseElement) {
            List<NLGElement> children = ((CoordinatedPhraseElement)phrase).getChildren();
            List<NLGElement> aggregated = this.apply(children);
            if (aggregated.size() == 1) {
                result = aggregated.get(0);
            } else {
                result = this.factory.createCoordinatedPhrase();
                for (NLGElement agg : aggregated) {
                    ((CoordinatedPhraseElement)result).addCoordinate(agg);
                }
            }
        }
        if (result != null) {
            for (String feature : phrase.getAllFeatureNames()) {
                result.setFeature(feature, phrase.getFeature(feature));
            }
        }
        return result;
    }

    public abstract NLGElement apply(NLGElement var1, NLGElement var2);
}

