/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.TableBase;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.PersistentStore;

public class RowAVL
extends Row {
    public NodeAVL nPrimaryNode;

    protected RowAVL(TableBase tableBase, Object[] objectArray) {
        super(tableBase, objectArray);
    }

    public RowAVL(TableBase tableBase, Object[] objectArray, int n) {
        super(tableBase, objectArray);
        this.position = n;
        this.setNewNodes();
    }

    public void setNewNodes() {
        int n = this.table.getIndexCount();
        NodeAVL nodeAVL = this.nPrimaryNode = new NodeAVL(this);
        for (int i = 1; i < n; ++i) {
            nodeAVL = nodeAVL.nNext = new NodeAVL(this);
        }
    }

    public NodeAVL getNode(int n) {
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (n-- > 0) {
            nodeAVL = nodeAVL.nNext;
        }
        return nodeAVL;
    }

    NodeAVL getNextNode(NodeAVL nodeAVL) {
        nodeAVL = nodeAVL == null ? this.nPrimaryNode : nodeAVL.nNext;
        return nodeAVL;
    }

    public NodeAVL insertNode(int n) {
        NodeAVL nodeAVL = this.getNode(n - 1);
        NodeAVL nodeAVL2 = new NodeAVL(this);
        nodeAVL2.nNext = nodeAVL.nNext;
        nodeAVL.nNext = nodeAVL2;
        return nodeAVL2;
    }

    public void clearNonPrimaryNodes() {
        NodeAVL nodeAVL = this.nPrimaryNode.nNext;
        while (nodeAVL != null) {
            nodeAVL.delete();
            nodeAVL.iBalance = 0;
            nodeAVL = nodeAVL.nNext;
        }
    }

    @Override
    public void delete(PersistentStore persistentStore) {
        NodeAVL nodeAVL = this.nPrimaryNode;
        while (nodeAVL != null) {
            nodeAVL.delete();
            nodeAVL = nodeAVL.nNext;
        }
    }

    @Override
    public void restore() {
    }

    @Override
    public void destroy() {
        ++JavaSystem.memoryRecords;
        this.clearNonPrimaryNodes();
        NodeAVL nodeAVL = this.nPrimaryNode.nNext;
        while (nodeAVL != null) {
            NodeAVL nodeAVL2 = nodeAVL;
            nodeAVL = nodeAVL.nNext;
            nodeAVL2.nNext = null;
        }
        this.nPrimaryNode = null;
    }
}

