/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.antrun;

import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.antrun.AntrunXmlPlexusConfigurationWriter;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.taskdefs.Typedef;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="run", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class AntRunMojo
extends AbstractMojo {
    public static final String DEFAULT_MAVEN_PROJECT_REFID = "maven.project";
    public static final String DEFAULT_MAVEN_PROJECT_HELPER_REFID = "maven.project.helper";
    public static final String DEFAULT_ANT_TARGET_NAME = "main";
    public static final String UTF_8 = "UTF-8";
    private String antTargetName;
    public static final String ANTLIB = "org/apache/maven/ant/tasks/antlib.xml";
    public static final String TASK_URI = "antlib:org.apache.maven.ant.tasks";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="plugin.artifacts", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(property="localRepository", readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter(defaultValue="")
    private String propertyPrefix;
    @Parameter(defaultValue="")
    private String customTaskPrefix = "";
    @Parameter(defaultValue="maven.project.dependencies.versions")
    private String versionsPropertyName;
    @Parameter
    private PlexusConfiguration tasks;
    @Parameter
    private PlexusConfiguration target;
    @Parameter(property="sourceRoot")
    private File sourceRoot;
    @Parameter(property="testSourceRoot")
    private File testSourceRoot;
    @Parameter(property="maven.antrun.skip", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean exportAntProperties;
    @Parameter(defaultValue="true")
    private boolean failOnError;
    public static final String DEPENDENCY_PREFIX = "maven.dependency.";

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info("Skipping Antrun execution");
            return;
        }
        MavenProject mavenProject = this.getMavenProject();
        if (this.tasks != null) {
            this.getLog().warn("Parameter tasks is deprecated, use target instead");
            this.target = this.tasks;
        }
        if (this.target == null) {
            this.getLog().info("No Ant target defined - SKIPPED");
            return;
        }
        if (this.propertyPrefix == null) {
            this.propertyPrefix = "";
        }
        try {
            Project antProject = new Project();
            File antBuildFile = this.writeTargetToProjectFile();
            ProjectHelper.configureProject(antProject, antBuildFile);
            antProject.init();
            DefaultLogger antLogger = new DefaultLogger();
            antLogger.setOutputPrintStream(System.out);
            antLogger.setErrorPrintStream(System.err);
            if (this.getLog().isDebugEnabled()) {
                antLogger.setMessageOutputLevel(4);
            } else if (this.getLog().isInfoEnabled()) {
                antLogger.setMessageOutputLevel(2);
            } else if (this.getLog().isWarnEnabled()) {
                antLogger.setMessageOutputLevel(1);
            } else if (this.getLog().isErrorEnabled()) {
                antLogger.setMessageOutputLevel(0);
            } else {
                antLogger.setMessageOutputLevel(3);
            }
            antProject.addBuildListener(antLogger);
            antProject.setBaseDir(mavenProject.getBasedir());
            Path p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getCompileClasspathElements().iterator(), File.pathSeparator));
            antProject.addReference("maven.dependency.classpath", p);
            antProject.addReference("maven.compile.classpath", p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getRuntimeClasspathElements().iterator(), File.pathSeparator));
            antProject.addReference("maven.runtime.classpath", p);
            p = new Path(antProject);
            p.setPath(StringUtils.join(mavenProject.getTestClasspathElements().iterator(), File.pathSeparator));
            antProject.addReference("maven.test.classpath", p);
            antProject.addReference("maven.plugin.classpath", this.getPathFromArtifacts(this.pluginArtifacts, antProject));
            antProject.addReference(DEFAULT_MAVEN_PROJECT_REFID, this.getMavenProject());
            antProject.addReference(DEFAULT_MAVEN_PROJECT_HELPER_REFID, this.projectHelper);
            antProject.addReference("maven.local.repository", this.localRepository);
            this.initMavenTasks(antProject);
            this.copyProperties(mavenProject, antProject);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("Executing tasks");
            }
            antProject.executeTarget(this.antTargetName);
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("Executed tasks");
            }
            this.copyProperties(antProject, mavenProject);
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("DependencyResolutionRequiredException: " + e.getMessage(), e);
        }
        catch (BuildException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("An Ant BuildException has occured: ").append(e.getMessage());
            String fragment = this.findFragment(e);
            if (fragment != null) {
                sb.append("\n").append(fragment);
            }
            if (!this.failOnError) {
                this.getLog().info(sb.toString(), e);
                return;
            }
            throw new MojoExecutionException(sb.toString(), e);
        }
        catch (Throwable e) {
            throw new MojoExecutionException("Error executing Ant tasks: " + e.getMessage(), e);
        }
        if (this.sourceRoot != null) {
            this.getLog().info("Registering compile source root " + this.sourceRoot);
            this.getMavenProject().addCompileSourceRoot(this.sourceRoot.toString());
        }
        if (this.testSourceRoot != null) {
            this.getLog().info("Registering compile test source root " + this.testSourceRoot);
            this.getMavenProject().addTestCompileSourceRoot(this.testSourceRoot.toString());
        }
    }

    public Path getPathFromArtifacts(Collection<Artifact> artifacts, Project antProject) throws DependencyResolutionRequiredException {
        if (artifacts == null) {
            return new Path(antProject);
        }
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Artifact a : artifacts) {
            File file = a.getFile();
            if (file == null) {
                throw new DependencyResolutionRequiredException(a);
            }
            list.add(file.getPath());
        }
        Path p = new Path(antProject);
        p.setPath(StringUtils.join(list.iterator(), File.pathSeparator));
        return p;
    }

    public void copyProperties(MavenProject mavenProject, Project antProject) {
        Properties mavenProps = mavenProject.getProperties();
        for (Map.Entry<Object, Object> entry : mavenProps.entrySet()) {
            antProject.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        antProject.setProperty("ant.file", mavenProject.getFile().getAbsolutePath());
        this.getLog().debug("Setting properties with prefix: " + this.propertyPrefix);
        antProject.setProperty(this.propertyPrefix + "project.groupId", mavenProject.getGroupId());
        antProject.setProperty(this.propertyPrefix + "project.artifactId", mavenProject.getArtifactId());
        antProject.setProperty(this.propertyPrefix + "project.name", mavenProject.getName());
        if (mavenProject.getDescription() != null) {
            antProject.setProperty(this.propertyPrefix + "project.description", mavenProject.getDescription());
        }
        antProject.setProperty(this.propertyPrefix + "project.version", mavenProject.getVersion());
        antProject.setProperty(this.propertyPrefix + "project.packaging", mavenProject.getPackaging());
        antProject.setProperty(this.propertyPrefix + "project.build.directory", mavenProject.getBuild().getDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.outputDirectory", mavenProject.getBuild().getOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testOutputDirectory", mavenProject.getBuild().getTestOutputDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.sourceDirectory", mavenProject.getBuild().getSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "project.build.testSourceDirectory", mavenProject.getBuild().getTestSourceDirectory());
        antProject.setProperty(this.propertyPrefix + "localRepository", this.localRepository.toString());
        antProject.setProperty(this.propertyPrefix + "settings.localRepository", this.localRepository.getBasedir());
        Set depArtifacts = mavenProject.getArtifacts();
        for (Artifact artifact : depArtifacts) {
            String propName = artifact.getDependencyConflictId();
            antProject.setProperty(this.propertyPrefix + propName, artifact.getFile().getPath());
        }
        StringBuilder versionsBuffer = new StringBuilder();
        for (Artifact artifact : depArtifacts) {
            versionsBuffer.append(artifact.getVersion()).append(File.pathSeparator);
        }
        antProject.setProperty(this.versionsPropertyName, versionsBuffer.toString());
        for (Artifact artifact : depArtifacts) {
            String propName = AntRunMojo.getDependencyArtifactPropertyName(artifact);
            antProject.setProperty(propName, artifact.getFile().getPath());
        }
    }

    public void copyProperties(Project antProject, MavenProject mavenProject) {
        if (!this.exportAntProperties) {
            return;
        }
        this.getLog().debug("Propagated Ant properties to Maven properties");
        Hashtable<String, Object> antProps = antProject.getProperties();
        Properties mavenProperties = mavenProject.getProperties();
        for (Map.Entry entry : antProps.entrySet()) {
            String key = (String)entry.getKey();
            if (mavenProperties.getProperty(key) != null) {
                this.getLog().debug("Ant property '" + key + "=" + mavenProperties.getProperty(key) + "' clashs with an existing Maven property, " + "SKIPPING this Ant property propagation.");
                continue;
            }
            mavenProperties.setProperty(key, (String)entry.getValue());
        }
    }

    public static String getDependencyArtifactPropertyName(Artifact artifact) {
        return DEPENDENCY_PREFIX + artifact.getGroupId() + "." + artifact.getArtifactId() + (artifact.getClassifier() != null ? "." + artifact.getClassifier() : "") + (artifact.getType() != null ? "." + artifact.getType() : "") + ".path";
    }

    public MavenProject getMavenProject() {
        return this.project;
    }

    public void initMavenTasks(Project antProject) {
        this.getLog().debug("Initialize Maven Ant Tasks");
        Typedef typedef = new Typedef();
        typedef.setProject(antProject);
        typedef.setResource(ANTLIB);
        if (!this.customTaskPrefix.equals("")) {
            typedef.setURI(TASK_URI);
        }
        typedef.execute();
    }

    private File writeTargetToProjectFile() throws IOException, PlexusConfigurationException {
        StringWriter writer = new StringWriter();
        AntrunXmlPlexusConfigurationWriter xmlWriter = new AntrunXmlPlexusConfigurationWriter();
        xmlWriter.write(this.target, writer);
        StringBuilder antProjectConfig = new StringBuilder(writer.getBuffer());
        this.stringReplace(antProjectConfig, "<tasks", "<target");
        this.stringReplace(antProjectConfig, "</tasks", "</target");
        this.antTargetName = this.target.getAttribute("name");
        if (this.antTargetName == null) {
            this.antTargetName = DEFAULT_ANT_TARGET_NAME;
            this.stringReplace(antProjectConfig, "<target", "<target name=\"main\"");
        }
        String xmlns = "";
        if (!this.customTaskPrefix.trim().equals("")) {
            xmlns = "xmlns:" + this.customTaskPrefix + "=\"" + TASK_URI + "\"";
        }
        String xmlHeader = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n";
        antProjectConfig.insert(0, "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        String projectOpen = "<project name=\"maven-antrun-\" default=\"" + this.antTargetName + "\" " + xmlns + " >\n";
        int index = antProjectConfig.indexOf("<target");
        antProjectConfig.insert(index, projectOpen);
        String projectClose = "\n</project>";
        antProjectConfig.append("\n</project>");
        String fileName = "build-" + this.antTargetName + ".xml";
        File buildFile = new File(this.project.getBuild().getDirectory(), "/antrun/" + fileName);
        buildFile.getParentFile().mkdirs();
        FileUtils.fileWrite(buildFile.getAbsolutePath(), UTF_8, antProjectConfig.toString());
        return buildFile;
    }

    public void stringReplace(StringBuilder text, String match, String with) {
        int index = text.indexOf(match);
        if (index != -1) {
            text.replace(index, index + match.length(), with);
        }
    }

    public String checkTargetName(PlexusConfiguration antTargetConfig) throws PlexusConfigurationException {
        String targetName = antTargetConfig.getAttribute("name");
        if (targetName == null) {
            targetName = DEFAULT_ANT_TARGET_NAME;
        }
        return targetName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findFragment(BuildException buildException) {
        if (buildException == null) return null;
        if (buildException.getLocation() == null) return null;
        if (buildException.getLocation().getFileName() == null) {
            return null;
        }
        antFile = new File(buildException.getLocation().getFileName());
        if (!antFile.exists()) {
            return null;
        }
        reader = null;
        try {
            reader = new LineNumberReader(ReaderFactory.newXmlReader(antFile));
            while ((line = reader.readLine()) != null) {
                if (reader.getLineNumber() != buildException.getLocation().getLineNumber()) continue;
                var5_6 = "around Ant part ..." + line.trim() + "... @ " + buildException.getLocation().getLineNumber() + ":" + buildException.getLocation().getColumnNumber() + " in " + antFile.getAbsolutePath();
                ** GOTO lbl24
            }
            ** GOTO lbl26
        }
        catch (Exception e) {
            try {
                this.getLog().debug(e.getMessage(), e);
                var5_7 = null;
            }
            catch (Throwable var6_8) {
                IOUtil.close(reader);
                throw var6_8;
            }
lbl24:
            // 1 sources

            IOUtil.close(reader);
            return var5_6;
lbl26:
            // 1 sources

            IOUtil.close(reader);
            return null;
            IOUtil.close(reader);
            return var5_7;
        }
    }
}

