/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.StringTokenizer;
import java.util.Vector;

public class ToUninvert
extends Transformation
implements Cloneable {
    private static final String INFO = "Uninvert";

    public static Vector<LexItem> Mutate(LexItem in, boolean detailsFlag, boolean mutateFlag) {
        String term = ToUninvert.Uninvert(in.GetSourceTerm());
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToUninvert.UpdateLexItem(in, term, 33, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        String testStr = ToUninvert.GetTestStr(args, "Angioplasty, Transluminal, Percutaneous Coronary");
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToUninvert.Mutate(in, true, true);
        ToUninvert.PrintResults(in, outs);
    }

    private static String Uninvert(String inStr) {
        Vector<String> tokenList = new Vector<String>();
        String delim = ",";
        StringTokenizer buf = new StringTokenizer(inStr, delim);
        while (buf.hasMoreTokens()) {
            tokenList.addElement(buf.nextToken());
        }
        String lastStr = new String();
        Vector<String> list = new Vector<String>();
        for (int i = 0; i < tokenList.size(); ++i) {
            String tempStr = (String)tokenList.elementAt(i);
            if (tempStr.startsWith(" ")) {
                list.addElement(lastStr);
                lastStr = new String(tempStr.trim());
                continue;
            }
            lastStr = lastStr.length() == 0 ? tempStr.trim() : lastStr + "," + tempStr.trim();
        }
        list.addElement(lastStr);
        StringBuffer buffer = new StringBuffer();
        for (int i = list.size() - 1; i >= 0; --i) {
            String tempStr = (String)list.elementAt(i);
            buffer.append(tempStr.trim());
            buffer.append(" ");
        }
        String outStr = buffer.toString();
        return outStr.trim();
    }
}

