/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.player;

import com.fabriziopolo.textcraft.objects.EmptyNoun;
import com.fabriziopolo.textcraft.player.InventoryItemTemperatureProvider;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.player.PlayerRainEffect;
import com.fabriziopolo.textcraft.player.PlayerSunEffect;
import com.fabriziopolo.textcraft.player.PlayerTemperatureEffect;
import com.fabriziopolo.textcraft.player.SuffocationSubmersionEffect;
import com.fabriziopolo.textcraft.player.WornItemLightFilter;
import com.fabriziopolo.textcraft.player.WornItemTemperatureFilter;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.characterbio.CharacterBioEffect;
import com.fabriziopolo.textcraft.states.characterbio.awake.AwakeState;
import com.fabriziopolo.textcraft.states.characterbio.energy.EnergyState;
import com.fabriziopolo.textcraft.states.characterbio.health.HealthState;
import com.fabriziopolo.textcraft.states.characterbio.hunger.HungerState;
import com.fabriziopolo.textcraft.states.characterbio.hydration.HydrationState;
import com.fabriziopolo.textcraft.states.characterbio.oxygen.OxygenState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.shade.ShadeState;
import com.fabriziopolo.textcraft.states.sun.SunState;
import com.fabriziopolo.textcraft.states.temperature.TemperatureFilterState;
import com.fabriziopolo.textcraft.states.water.SubmersionEffectState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectState;
import com.fabriziopolo.textcraft.worldbuilder.WorldBuilder;

public final class DefaultPlayerBuilder
extends WorldBuilder {
    public DefaultPlayerBuilder(Simulation simulation) {
        super(simulation);
    }

    public void buildPlayer(Player player, Noun startRoom) {
        HealthState.requestChangeWithoutCause(player, 1.0, this.simulation);
        this.simulation.update();
        HungerState.requestChangeWithoutCause(player, 1.0, this.simulation);
        HydrationState.requestChangeWithoutCause(player, 1.0, this.simulation);
        EnergyState.requestChangeWithoutCause(player, 1.0, this.simulation);
        OxygenState.requestChangeWithoutCause(player, 1.0, this.simulation);
        SunState.requestSetSunEffect(player, PlayerSunEffect.fromPerGameDayRate(-0.8), this.simulation);
        this.createUpdateable((noun, simulation) -> CharacterBioEffect.dayTimeScaleBuilder(simulation).addHydration(-0.2).build().apply(simulation, player, null, false));
        RainEffectState.requestSetRainEffect(player, new PlayerRainEffect(), this.simulation);
        SubmersionEffectState.requestSetSubmersionEffect(player, new SuffocationSubmersionEffect(), this.simulation);
        this.setTemperatureEffect(player, new PlayerTemperatureEffect());
        this.makeUntakeable(player, "You've always been rather taken with yourself.");
        EmptyNoun playerEntrance = new EmptyNoun();
        PositionState.requestPutEntrance(player, null, playerEntrance, this.simulation);
        ShadeState.requestSetLightFilter(playerEntrance, new WornItemLightFilter(player), this.simulation);
        TemperatureFilterState.requestSetTemperatureFilter((Noun)playerEntrance, new WornItemTemperatureFilter(player), this.simulation);
        this.setTemperature((Noun)player, new InventoryItemTemperatureProvider(player));
        this.setNotWaiting(player);
        AwakeState.requestSleep(player, this.simulation);
        this.simulation.update();
        this.putInRoom(player, startRoom);
    }
}

