/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.world.dsl.crafts;

import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithAlternatePlural;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithPrepositionalPhrase;
import com.fabriziopolo.textcraft.nlg.Number;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.nlg.SimpleNounAutoBuilder;
import com.fabriziopolo.textcraft.objects.LiquidContainerNoun;
import com.fabriziopolo.textcraft.objects.NounOfContents;
import com.fabriziopolo.textcraft.objects.SimpleNoun;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.edibility.EatContentsEatHandler;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import com.fabriziopolo.textcraft.states.takeable.ContainerTakeHandler;
import com.fabriziopolo.textcraft.states.time.TimeState;
import com.fabriziopolo.textcraft.states.updatable.PeriodicUpdatable;
import com.fabriziopolo.textcraft.states.updatable.Updateable;
import com.fabriziopolo.textcraft.states.water.WaterState;
import com.fabriziopolo.timecraft.capabilities.ResourceCapabilities;
import com.fabriziopolo.timecraft.capabilities.ToolCapabilities;
import com.fabriziopolo.timecraft.world.constants.Encumbrances;
import com.fabriziopolo.timecraft.world.dsl.Dsl;
import com.fabriziopolo.timecraft.world.dsl.beach.Plants;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Tools
extends Dsl {
    private static final long FISH_TRAP_CATCH_DELAY_HOURS = 18L;
    private static final double FISH_TRAP_CATCH_PROBABILITY = 0.4;

    public Tools(Simulation simulation) {
        super(simulation);
    }

    public Noun rustyScrewdriver(Simulation simulation) {
        SimpleNoun screwdriver = SimpleNoun.auto("This phillips head screwdriver is rusted and worn.", "a rusty screwdriver", "screwdrivers", new String[0]);
        SimpleNoun rust = SimpleNoun.auto("The screwdriver has rusted rapidly due to exposure to saltwater.", "rust", "rusts", new String[0]);
        this.addIntegralFeature(rust, Prepositions.on, screwdriver, simulation);
        this.setEncumbrance(screwdriver, Encumbrances.HALF_HAND_SIZED);
        return screwdriver;
    }

    private void addIntegralFeature(Noun feature, Preposition preposition, Noun noun, Simulation simulation) {
        PositionState.requestPut(noun, preposition, Prepositions.guessInverseOf(preposition), feature, simulation);
        StructureState.requestMakeIntegral(feature, simulation);
    }

    public Noun pocketFluff(final Noun player) {
        final SimpleNoun pocketFluff = SimpleNoun.auto("I guess the Brits call it 'fluff'.  I'd call it 'lint'.", "pocket fluff", "fluffs", "pocket lint", "lints");
        this.setEncumbrance(pocketFluff, Encumbrances.NONE);
        this.addResourceCapability(pocketFluff, ResourceCapabilities.TINDER_MATERIAL);
        this.makeDisappearWhenDropped(pocketFluff);
        this.setUpdateable(pocketFluff, new PeriodicUpdatable(Duration.ofHours(12L), Duration.ofHours(11L), new Updateable(){

            @Override
            public void update(Noun noun, Simulation simulation) {
                Frame frame = simulation.getCurrentFrame();
                List<Noun> itemList = InventoryState.getItemList(player, frame);
                if (!itemList.contains(pocketFluff)) {
                    PositionState.requestRemove(pocketFluff, simulation);
                    InventoryState.requestAddItemWithoutNotifying(player, pocketFluff, simulation);
                }
            }
        }));
        return pocketFluff;
    }

    public Noun knife() {
        return this.knife(null, new ArrayList<Noun>());
    }

    public Noun knife(AdjectivePhrase adjective, List<Noun> resources) {
        String verboseDescription;
        String autoNounPhrase;
        Noun bladeMaterial = null;
        Noun handleMaterial = null;
        if (resources.size() >= 1) {
            bladeMaterial = resources.get(0);
        }
        if (resources.size() >= 2) {
            handleMaterial = resources.get(1);
        }
        if (bladeMaterial != null) {
            NounPhrase bladeDescr = bladeMaterial.getContextFreeDescription();
            autoNounPhrase = "a ";
            if (adjective != null) {
                autoNounPhrase = autoNounPhrase + adjective + " ";
            }
            autoNounPhrase = autoNounPhrase + bladeDescr + " knife";
            if (handleMaterial != null) {
                verboseDescription = "This ";
                if (adjective != null) {
                    verboseDescription = verboseDescription + adjective + " ";
                }
                verboseDescription = verboseDescription + bladeDescr + " knife has a handle made of " + handleMaterial.getContextFreeDescription() + ".";
            } else {
                verboseDescription = "This knife has a blade made of " + bladeDescr + ".";
            }
        } else {
            autoNounPhrase = "a knife";
            verboseDescription = "This knife is hand-made.";
        }
        SimpleNoun knife = SimpleNoun.auto(verboseDescription, autoNounPhrase, "knives", new String[0]);
        this.setEncumbrance(knife, Encumbrances.HALF_HAND_SIZED);
        return knife;
    }

    public Noun prototypeAxe() {
        return new SimpleNounAutoBuilder().setDescription("", "an axe", "axes", "ax", "axs").build();
    }

    public Noun axe(AdjectivePhrase adjectivePhrase, List<Noun> resources) {
        if (resources.size() != 3) {
            throw new IllegalArgumentException();
        }
        Noun bladeNoun = resources.get(0);
        Noun handleMaterialNoun = resources.get(1);
        Noun bindingMaterialNoun = resources.get(2);
        NounPhrase blade = bladeNoun.getContextFreeDescription();
        NounPhrase handle = handleMaterialNoun.getContextFreeDescription();
        NounPhrase binding = bindingMaterialNoun.getContextFreeDescription();
        String bladeMaterial = blade.toString();
        if (bladeMaterial.endsWith(" blade")) {
            bladeMaterial = bladeMaterial.substring(0, bladeMaterial.length() - " blade".length());
        }
        String _adjective_ = adjectivePhrase == null ? " " : " " + adjectivePhrase + " ";
        SimpleNoun axe = new SimpleNounAutoBuilder().setDescription("This" + _adjective_ + "axe was constructed by binding " + NounPhraseWithArticle.a(blade) + " to " + NounPhraseWithArticle.a(handle) + " with " + NounPhraseWithArticle.a(binding) + ".", "a" + _adjective_ + bladeMaterial + " axe", "axes", "ax", "axs").build();
        this.setEncumbrance(axe, Encumbrances.ARM_SIZED);
        this.addToolCapability(axe, ToolCapabilities.TREE_CUTTING);
        return axe;
    }

    public Noun prototypeBlade() {
        return new SimpleNounAutoBuilder().setDescription("", "a blade", "blades", new String[0]).build();
    }

    public Noun blade(AdjectivePhrase adjectivePhrase, List<Noun> resources) {
        if (resources.size() != 1) {
            throw new IllegalArgumentException();
        }
        Noun materialNoun = resources.get(0);
        NounPhrase material = materialNoun.getContextFreeDescription();
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("A blade, hand-made from " + material + ".", "a " + material + " blade", "blades", new String[0]).build();
        this.setEncumbrance(obj, Encumbrances.HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.BLADE);
        return obj;
    }

    public Noun stone() {
        SimpleNoun obj = new SimpleNounAutoBuilder().setDescription("A smooth round medium sized rock that fills your hand.  Looking at it fills you with the desire to smash something.", "a stone", "stones", "a smooth round medium sized stone", "stones", "a smooth round medium sized rock", "rocks").build();
        this.setEncumbrance(obj, Encumbrances.HAMMER_HEAD_SIZED);
        this.addToolCapability(obj, ToolCapabilities.HAMMER);
        return obj;
    }

    public Noun plasticBottle() {
        SimpleNoun bottleDelegate = SimpleNoun.auto("This plastic bottle once washed up on shore as garbage.", "a plastic bottle", "bottles", new String[0]);
        LiquidContainerNoun bottle = new LiquidContainerNoun(bottleDelegate);
        this.setTakeHandler(bottle, new ContainerTakeHandler());
        this.setEncumbrance(bottle, Encumbrances.HAND_SIZED);
        this.setEatHandler(bottle, new EatContentsEatHandler());
        this.addToolCapability(bottle, ToolCapabilities.LIQUID_CONTAINER);
        return bottle;
    }

    public Noun can() {
        SimpleNoun canDescription = SimpleNoun.auto("You like to imagine that this steel can once contained lima beans.  It's a bit rusty but the lid is still attached so it could make a useful container.", "a rusty can", "cans", new String[0]);
        LiquidContainerNoun can = new LiquidContainerNoun(canDescription);
        this.setTakeHandler(can, new ContainerTakeHandler());
        this.setEncumbrance(can, Encumbrances.HAND_SIZED);
        this.addToolCapability(can, ToolCapabilities.LIQUID_CONTAINER);
        this.beach().plants();
        this.setRainEffect(can, Plants.fillContainerRainEffect);
        return can;
    }

    public Noun glassLense() {
        NounPhrase piece = Nlg.autoNounPhrase("a piece", "pieces", new String[0]);
        NounPhrase singularDescription = Nlg.autoNounPhrase("clear glass", null, new String[0]);
        NounPhraseWithPrepositionalPhrase description = NounPhraseWithPrepositionalPhrase.builder().setBaseNounPhrase(piece).setPreposition(Prepositions.of).setObjectOfPreposition(singularDescription).setMatchAsObjectOfPreposition(true).build();
        SimpleNoun obj = SimpleNoun.builder().setDescription(description, Nlg.literalSentences("This piece of clear glass looks like it used to be the bottom of a Coke bottle.  It's curved and probably focuses light pretty well.  You might be able to fry some ants or craft a fire with it as a tool.")).build();
        this.setEncumbrance(obj, Encumbrances.HALF_HAND_SIZED);
        this.addResourceCapability(obj, ResourceCapabilities.BLADE_MATERIAL);
        this.addToolCapability(obj, ToolCapabilities.FIRE_MAKING_WITH_LIGHT);
        return obj;
    }

    public Noun prototypeFishTrap() {
        return new SimpleNounAutoBuilder().setDescription("", "a concial basket fish trap", "traps", new String[0]).build();
    }

    public Noun fishTrap(AdjectivePhrase adjectivePhrase, List<Noun> resources) {
        if (resources.size() != 1) {
            throw new IllegalArgumentException();
        }
        Noun materialNoun = resources.get(0);
        final NounPhrase material = materialNoun.getContextFreeDescription();
        final String _adjective_ = adjectivePhrase == null ? " " : " " + adjectivePhrase + " ";
        final NounOfContents trap = new NounOfContents(){
            private final String verboseDescriptionBody;
            {
                this.verboseDescriptionBody = "This trap is clever.  The fish are stupid.  Large and small cones have been woven out of " + material + ".  The smaller one is inverted and put inside the large one.  The fish " + "swim into the small cone, end up inside the big cone, and can't find their way out again.";
            }

            @Override
            protected Noun getDelegateBasedOnContents(Noun object, List<Noun> contents, Frame frame) {
                if (contents.isEmpty()) {
                    return new SimpleNounAutoBuilder().setDescription(this.verboseDescriptionBody + "  That's the plan, at least.", "an empty" + _adjective_ + "fish trap", "traps", new String[0]).build();
                }
                Noun representativeContent = contents.get(0);
                NounPhrase representativeContentPerception = representativeContent.getDefaultPerception(frame);
                NounPhraseWithAlternatePlural description = new NounPhraseWithAlternatePlural(Nlg.autoNounPhrase("a" + _adjective_ + "fish trap with " + NounPhraseWithArticle.a(representativeContentPerception) + " in it", "traps", new String[0]), Nlg.autoNounPhrase("a" + _adjective_ + "fish traps with " + representativeContentPerception.as(Number.Plural) + " in it", "them", new String[0]));
                return new SimpleNounAutoBuilder().setDescription(Nlg.literalSentences("The trap has caught " + NounPhraseWithArticle.a(representativeContentPerception) + "!  " + this.verboseDescriptionBody), description).build();
            }
        };
        this.setUpdateable(trap, new Updateable(){
            private final Random random;
            Instant lastTimeOutOfWater;
            {
                this.random = Tools.this.simulation.getRandom();
                this.lastTimeOutOfWater = null;
            }

            @Override
            public void update(Noun noun, Simulation simulation) {
                Duration timeInWater;
                Frame frame = simulation.getCurrentFrame();
                Instant now = TimeState.get(frame).getGameTimeInstant();
                if (!WaterState.isInWater(trap, frame)) {
                    this.lastTimeOutOfWater = now;
                }
                if (this.lastTimeOutOfWater != null && (timeInWater = Duration.between(this.lastTimeOutOfWater, now)).toHours() > 18L) {
                    if (!StructureState.getNonintegralChildren(trap, frame).isEmpty()) {
                        this.lastTimeOutOfWater = now;
                        return;
                    }
                    if (this.random.nextDouble() < 0.4) {
                        Dsl dsl = new Dsl(simulation);
                        dsl.put(dsl.beach().animals().fish(), Prepositions.in, trap);
                    }
                    this.lastTimeOutOfWater = now;
                }
            }
        });
        this.setEncumbrance(trap, Encumbrances.ARM_SIZED);
        return trap;
    }
}

