/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft.game;

import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.commands.AbstractCraftCommand;
import com.fabriziopolo.textcraft.commands.AggregateCraftCommand;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.DebugExamineCommand;
import com.fabriziopolo.textcraft.commands.DropCommand;
import com.fabriziopolo.textcraft.commands.EatCommand;
import com.fabriziopolo.textcraft.commands.ExamineCommand;
import com.fabriziopolo.textcraft.commands.GoCommand;
import com.fabriziopolo.textcraft.commands.GoPrepositionCommand;
import com.fabriziopolo.textcraft.commands.HelpCommand;
import com.fabriziopolo.textcraft.commands.InventoryCommand;
import com.fabriziopolo.textcraft.commands.LookCommand;
import com.fabriziopolo.textcraft.commands.LookDirectionCommand;
import com.fabriziopolo.textcraft.commands.MenuCommand;
import com.fabriziopolo.textcraft.commands.PauseCommand;
import com.fabriziopolo.textcraft.commands.PutCommand;
import com.fabriziopolo.textcraft.commands.RemoveCommand;
import com.fabriziopolo.textcraft.commands.SleepCommand;
import com.fabriziopolo.textcraft.commands.StatusCommand;
import com.fabriziopolo.textcraft.commands.TakeCommand;
import com.fabriziopolo.textcraft.commands.UnwieldCommand;
import com.fabriziopolo.textcraft.commands.UseCommand;
import com.fabriziopolo.textcraft.commands.WaitCommand;
import com.fabriziopolo.textcraft.commands.WearCommand;
import com.fabriziopolo.textcraft.commands.WieldCommand;
import com.fabriziopolo.textcraft.commands.WikiCommand;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.simulation.UpdateParameters;
import com.fabriziopolo.textcraft.text.InputParser;
import com.fabriziopolo.timecraft.alphaisland.commands.CreditsCommand;
import com.fabriziopolo.timecraft.commands.Builds;
import com.fabriziopolo.timecraft.commands.Crafts;
import com.fabriziopolo.timecraft.game.TimeCraftGameBase;
import com.fabriziopolo.timecraft.world.map.alpha.AlphaWorldMapBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;

public class AlphaIslandGame
extends TimeCraftGameBase {
    public static final String VERSION = "1.04";
    private static final double DEFAULT_DT = 1.0;
    private static final double DEFAULT_TIMESCALE = 96.0;
    public static final UpdateParameters DEFAULT_UPDATE_PARAMETERS = new UpdateParameters(1.0, 96.0);

    public AlphaIslandGame() {
        super("TextCraft", "Alpha Island", VERSION);
    }

    @Override
    protected String getTitleArt() {
        return "\n\n\n\n\n\n\n\n\n\n\n\n\n\n                                  _\n                                 /_'. _\n                               _   \\ / '-.\n                              < ``-.;),--'`\n                               '--.</()`--.\n                                 / |/-/`'._\\\n                                 |/ |=|\n                                    |_|\n                               ~`   |-| ~~      ~\n                           ~~  ~~ __|=|__   ~~\n                         ~~   .-'`  |_|  ``\"\"-._   ~~\n                          ~~.'      |=|    O    '-.  ~\n                            |      `\"\"\"`  <|\\      \\   ~\n                        ~   \\              |\\      | ~~\n                         jgs '-.__.--._    |/   .-'\n                                  ~~   `--...-'`    ~~\n                          ~~         ~          ~\n                                 ~~         ~~     ~\n\n\n             " + this.getTextCraftName() + ": " + this.getEpisodeName() + " v" + this.getVersion() + " (c) Fabrizio Polo 2017\n" + "            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n" + "\n" + "\n" + "\n" + "\n";
    }

    @Override
    public Supplier<SinglePlayerGameState> getInitialGameStateCreator() {
        return new CreateInitialAlphaIslandGameState(this);
    }

    private InputParser createInputParser(Simulation simulation) {
        InputParser parser = new InputParser();
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(new GoCommand());
        commands.add(new LookCommand());
        commands.add(new LookDirectionCommand());
        commands.add(new ExamineCommand());
        commands.add(new InventoryCommand());
        commands.add(new TakeCommand());
        commands.add(new DropCommand());
        commands.add(new StatusCommand());
        commands.add(new EatCommand());
        commands.add(new WieldCommand());
        commands.add(new UnwieldCommand());
        commands.add(new SleepCommand());
        commands.add(new WaitCommand());
        commands.add(new GoPrepositionCommand());
        commands.add(new WearCommand());
        commands.add(new RemoveCommand());
        commands.add(new PutCommand());
        commands.add(new UseCommand());
        commands.add(new PauseCommand());
        AlphaIslandGame.addCraftingCommands(commands, simulation);
        commands.add(new CreditsCommand());
        this.addDebugCommands(commands);
        commands.add(new MenuCommand(new CreateInitialAlphaIslandGameState(this)));
        commands.add(new HelpCommand(commands));
        parser.addCommands(commands);
        return parser;
    }

    private static List<AbstractCraftCommand> getCraftingCommands(Simulation simulation) {
        Crafts crafts = new Crafts(simulation);
        ArrayList<AbstractCraftCommand> craftCommands = new ArrayList<AbstractCraftCommand>();
        craftCommands.add(crafts.axe());
        craftCommands.add(crafts.blade());
        craftCommands.add(crafts.fishTrap());
        craftCommands.add(crafts.hat());
        craftCommands.add(crafts.bra());
        craftCommands.add(crafts.belt());
        craftCommands.add(crafts.mat());
        craftCommands.add(crafts.wovenMaterial());
        Builds builds = new Builds(simulation);
        craftCommands.add(builds.leanToShelter());
        craftCommands.add(builds.fire());
        return craftCommands;
    }

    private static void addCraftingCommands(List<Command> commands, Simulation simulation) {
        commands.add(new AggregateCraftCommand(AlphaIslandGame.getCraftingCommands(simulation)));
    }

    private void addDebugCommands(List<Command> commands) {
        commands.add(new DebugExamineCommand());
        commands.add(new WikiCommand());
    }

    public SinglePlayerSimulation createEmptyAlphaIslandGameSimulation() {
        return new SinglePlayerSimulation(this.createSeedFrame(), new Player(), DEFAULT_UPDATE_PARAMETERS, new Random(0L));
    }

    private SinglePlayerSimulation createAlphaIslandGameSimulation() {
        SinglePlayerSimulation simulation = this.createEmptyAlphaIslandGameSimulation();
        AlphaIslandGame.installAutoSaver(simulation);
        new AlphaWorldMapBuilder(simulation).buildWorld();
        return simulation;
    }

    private static final class CreateInitialAlphaIslandGameState
    implements Supplier<SinglePlayerGameState>,
    Serializable {
        private final AlphaIslandGame game;

        private CreateInitialAlphaIslandGameState(AlphaIslandGame game) {
            this.game = game;
        }

        @Override
        public SinglePlayerGameState get() {
            SinglePlayerSimulation simulation = this.game.createAlphaIslandGameSimulation();
            InputParser inputParser = this.game.createInputParser(simulation);
            return new SinglePlayerGameState(inputParser, simulation);
        }
    }
}

