/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.weather.rain;

import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.State;
import com.fabriziopolo.textcraft.states.ValueState;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffect;
import com.fabriziopolo.textcraft.states.weather.rain.RainEffectStateBuilder;
import com.fabriziopolo.textcraft.states.weather.rain.RainTracePathAlgorithm;
import com.fabriziopolo.textcraft.text.DebugInfoBuilder;
import java.util.Map;

public class RainEffectState
extends ValueState<RainEffect> {
    @Override
    protected RainEffect combineValues(Noun noun, RainEffect t1, RainEffect t2, Simulation simulation) {
        return t2;
    }

    @Override
    protected Class getStateKey() {
        return RainEffectState.class;
    }

    @Override
    public State updateState(Simulation simulation) {
        RainEffectState newState = this.getUpdatedRainHandlerState(simulation);
        return newState;
    }

    @Override
    public String getDebugInfo(Noun noun, Frame frame) {
        DebugInfoBuilder builder = new DebugInfoBuilder(this.getStateKey());
        builder.addLine("effect", this.get(noun));
        builder.addLine("isRainingOn", RainEffectState.isRainingOn(noun, frame));
        return builder.toString();
    }

    private RainEffectState getUpdatedRainHandlerState(Simulation simulation) {
        RainEffectStateBuilder builder = new RainEffectStateBuilder();
        this.setUpdatedState(simulation, builder);
        return builder.build();
    }

    public static RainEffectStateBuilder builder() {
        return new RainEffectStateBuilder();
    }

    public static void invokeRainEffects(double intensity, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        RainEffectState rainEffectState = RainEffectState.get(frame);
        for (Map.Entry entry : rainEffectState.getEntrySet()) {
            Noun noun = entry.getKey();
            RainEffect onExposureToRain = (RainEffect)entry.getValue();
            if (!RainEffectState.isRainingOn(noun, frame)) continue;
            onExposureToRain.onRain(noun, intensity, simulation);
        }
    }

    public static boolean isRainingOn(Noun noun, Frame frame) {
        return new RainTracePathAlgorithm().isRainingOn(noun, frame);
    }

    public static void requestSetRainEffect(Noun noun, RainEffect effect, Simulation simulation) {
        simulation.requestStateChange(RainEffectState.class, new ValueState.ChangeRequest<RainEffect>(noun, effect));
    }

    private static RainEffectState get(Frame currentFrame) {
        return (RainEffectState)currentFrame.states.get(RainEffectState.class);
    }
}

