/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.inventory;

import com.fabriziopolo.textcraft.events.inventory.TakeObjectEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Pronouns;
import com.fabriziopolo.textcraft.nlg.Verbs;
import com.fabriziopolo.textcraft.player.Player;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.inventory.InventoryState;
import com.fabriziopolo.textcraft.states.inventory.InventoryStateChangeRequest;
import java.util.ArrayList;
import java.util.Collection;

public final class InventoryAddItemsRequest
implements InventoryStateChangeRequest {
    private final Noun person;
    private final Collection<Noun> items;
    private final boolean notify;

    private InventoryAddItemsRequest(Noun person, Collection<Noun> items, boolean notify) {
        this.items = items;
        this.person = person;
        this.notify = notify;
    }

    public static InventoryAddItemsRequest create(Noun person, Noun item) {
        ArrayList<Noun> items = new ArrayList<Noun>();
        items.add(item);
        return new InventoryAddItemsRequest(person, items, true);
    }

    public static InventoryAddItemsRequest createNoNotify(Noun person, Noun item) {
        ArrayList<Noun> items = new ArrayList<Noun>();
        items.add(item);
        return new InventoryAddItemsRequest(person, items, false);
    }

    public static InventoryAddItemsRequest create(Noun person, Collection<Noun> items) {
        return new InventoryAddItemsRequest(person, items, true);
    }

    @Override
    public void apply(InventoryState.Builder builder, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        for (Noun item : this.items) {
            builder.give(this.person, item);
            if (!this.notify) continue;
            simulation.postEvent(new TakeObjectEvent(this.person, item, (event, perceiver, channel, frame1) -> Nlg.simpleSentence(Pronouns.You, Verbs.take, NounPhraseWithArticle.a(event.getObject().asPerceivedBy(perceiver, frame1, channel)))));
        }
    }

    public static void post(Player player, Noun objectToAdd, Simulation simulation) {
        ArrayList<Noun> objects = new ArrayList<Noun>();
        objects.add(objectToAdd);
        simulation.requestStateChange(InventoryState.class, new InventoryAddItemsRequest(player, objects, true));
    }
}

