/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.edibility;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.edibility.DefaultEatHandler;
import com.fabriziopolo.textcraft.states.structure.StructureState;
import java.util.Set;

public class EatContentsEatHandler
extends DefaultEatHandler {
    @Override
    public Noun getObjectToEat(Noun objectToEat, Frame frame) {
        Set<Noun> contents = StructureState.getNonintegralChildren(objectToEat, frame);
        return contents.stream().findFirst().orElse(null);
    }

    @Override
    public void onNoObjectToEat(Perceiver consumer, Noun objectToEat, Simulation simulation) {
        if (objectToEat == null) {
            super.onNoObjectToEat(consumer, objectToEat, simulation);
            return;
        }
        NounPhrase perceptionOfObjectToEat = objectToEat.getContextFreeDescription();
        if (perceptionOfObjectToEat == null) {
            super.onNoObjectToEat(consumer, objectToEat, simulation);
            return;
        }
        String emptyMessage = NounPhraseWithArticle.the(perceptionOfObjectToEat) + " is empty";
        PlayerNotificationEvent.postAlwaysPerceivable(consumer, Nlg.literalClauseSentence(emptyMessage).toString(), simulation);
    }
}

