/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.NlgObject;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.text.TextMatcher;

public class PrepositionalPhrase
implements NlgObject,
TextMatcher {
    private final Preposition preposition;
    private final NounPhrase nounPhrase;

    public PrepositionalPhrase(Preposition preposition, NounPhrase nounPhrase) {
        this.preposition = preposition;
        this.nounPhrase = nounPhrase;
    }

    public String toString() {
        return this.preposition + " " + this.nounPhrase;
    }

    @Override
    public TextMatcher.Result matches(String[] words, int startIndex, Frame frame) {
        int idx = startIndex;
        if (idx >= words.length) {
            return TextMatcher.Result.createFailed();
        }
        if (!words[idx].toLowerCase().equals(this.preposition.toString())) {
            return TextMatcher.Result.createFailed();
        }
        TextMatcher.Result nounMatch = this.nounPhrase.matches(words, ++idx, frame);
        return TextMatcher.Result.createMatch(startIndex, 1 + nounMatch.numWordsMatched);
    }
}

