/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.nlg;

import com.fabriziopolo.textcraft.nlg.AdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.Articles;
import com.fabriziopolo.textcraft.nlg.IndependentClause;
import com.fabriziopolo.textcraft.nlg.NounPhrase;
import com.fabriziopolo.textcraft.nlg.PureAdjectivePhrase;
import com.fabriziopolo.textcraft.nlg.PureIndependentClause;
import com.fabriziopolo.textcraft.nlg.PureSentences;
import com.fabriziopolo.textcraft.nlg.PureVerbPhrase;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SimpleClause;
import com.fabriziopolo.textcraft.nlg.SimpleNounPhrase;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.nlg.VerbPhrase;
import com.fabriziopolo.textcraft.nlg.VerbPhraseWithObject;
import com.fabriziopolo.textcraft.text.Text;

public final class Nlg {
    private Nlg() {
    }

    public static NounPhrase autoNounPhrase(String fullString) {
        if (fullString == null) {
            return null;
        }
        return Nlg.autoNounPhraseBuilder(fullString).build();
    }

    public static NounPhrase autoNounPhrase(String fullString, String pluralNounString, String ... alternatives) {
        SimpleNounPhrase.Builder builder = Nlg.autoNounPhraseBuilder(fullString).setPlural(pluralNounString);
        if (alternatives != null) {
            for (int i = 0; i < alternatives.length; i += 2) {
                String autoString = alternatives[i];
                if (alternatives.length <= i + 1) {
                    throw new IllegalArgumentException("Alternative matchables must be passed in in the form  auto-string, plural, auto-string, plural...");
                }
                String plural = alternatives[i + 1];
                builder.addAlternativeMatchableNounPhrase(Nlg.autoNounPhrase(autoString, plural, new String[0]));
            }
        }
        return builder.build();
    }

    public static SimpleNounPhrase.Builder autoNounPhraseBuilder(String fullString) {
        SimpleNounPhrase.Builder builder = SimpleNounPhrase.builder();
        String[] words = Text.parseIntoWords(fullString);
        if (words.length == 0) {
            throw new IllegalArgumentException("Cannot parse string into a noun phrase: \"" + fullString + "\".");
        }
        int idx = 0;
        if (Articles.isIndefiniteArticle(words[idx])) {
            builder.setIsCountNoun(true);
            ++idx;
        } else {
            builder.setIsCountNoun(false);
        }
        while (idx < words.length - 1) {
            builder.addAdjective(Nlg.pureAdjective(words[idx]));
            ++idx;
        }
        builder.setSingular(words[words.length - 1]);
        return builder;
    }

    public static AdjectivePhrase pureAdjective(String adjective) {
        return new PureAdjectivePhrase(adjective);
    }

    public static VerbPhrase pureVerb(String secondPersonSingular, String secondPersonPlural, String thirdPersonSingular, String thirdPersonPlural) {
        return new PureVerbPhrase(secondPersonSingular, secondPersonPlural, thirdPersonSingular, thirdPersonPlural);
    }

    public static Sentences simpleSentence(NounPhrase subject, VerbPhrase verb) {
        return SingleClauseSentence.create(SimpleClause.create(subject, verb));
    }

    public static Sentences simpleSentence(NounPhrase subject, VerbPhrase verb, NounPhrase object) {
        return SingleClauseSentence.create(SimpleClause.create(subject, new VerbPhraseWithObject(verb, object)));
    }

    public static Sentences literalSentences(String literal) {
        return new PureSentences(literal);
    }

    public static IndependentClause literalClause(String literal) {
        return new PureIndependentClause(literal);
    }

    public static Sentences literalClauseSentence(String literal) {
        return SingleClauseSentence.create(new PureIndependentClause(literal));
    }
}

