/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.events.position;

import com.fabriziopolo.textcraft.nlg.Nlg;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.simulation.Event;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.simulation.perception.PerceptionChannel;
import java.util.ArrayList;
import java.util.Collections;

public class PlayerDebugExaminesNoun
implements Event {
    private final Noun noun;

    public PlayerDebugExaminesNoun(Noun noun) {
        this.noun = noun;
    }

    @Override
    public Sentences asPerceivedBy(Perceiver perceiver, Frame frame, PerceptionChannel channel) {
        if (this.noun == null) {
            return null;
        }
        ArrayList infoLines = new ArrayList();
        frame.states.forEach((key, state) -> {
            String info = state.getDebugInfo(this.noun, frame);
            if (info != null) {
                infoLines.add(info);
            }
        });
        Collections.sort(infoLines, String.CASE_INSENSITIVE_ORDER);
        StringBuilder builder = new StringBuilder();
        infoLines.forEach(line -> builder.append((String)line));
        return Nlg.literalSentences(builder.toString());
    }

    @Override
    public boolean isAlwaysPerceivable() {
        return true;
    }
}

