/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.app;

import com.fabriziopolo.textapp.TextAppController;
import com.fabriziopolo.textcraft.app.NumericTextMenu;
import com.fabriziopolo.textcraft.app.SinglePlayerGameState;
import com.fabriziopolo.textcraft.app.TextPrinter;
import com.fabriziopolo.textcraft.commands.ActionsAndHints;
import com.fabriziopolo.textcraft.commands.Command;
import com.fabriziopolo.textcraft.commands.UserAction;
import com.fabriziopolo.textcraft.simulation.SinglePlayerSimulation;
import com.fabriziopolo.textcraft.text.InputParser;
import java.util.List;

public final class StatefulParserExecutor {
    private NumericTextMenu currentMenu = null;

    public boolean onParsedInput(String input, TextAppController controller) {
        if (input.isEmpty()) {
            return false;
        }
        TextPrinter txt = controller.getTxt();
        SinglePlayerGameState gameState = controller.getGameState();
        txt.logInput(input);
        txt.println();
        SinglePlayerSimulation simulation = gameState.getSimulation();
        if (this.currentMenu != null) {
            NumericTextMenu prevMenu = this.currentMenu;
            boolean handledInput = this.currentMenu.parseInput(input, controller);
            if (!this.currentMenu.isPersistent() && handledInput && prevMenu == this.currentMenu) {
                this.currentMenu = null;
            }
            if (handledInput) {
                controller.getUi().clearInput();
                return true;
            }
        } else {
            try {
                int i = Integer.parseInt(input);
                txt.println("There is no active menu.");
                controller.getUi().clearInput();
                return false;
            }
            catch (NumberFormatException i) {
                // empty catch block
            }
        }
        Command.Context context = new Command.Context(simulation.player, simulation);
        ActionsAndHints actionsAndHints = gameState.parse(input, context);
        if (actionsAndHints.actions.size() == 0) {
            this.handleNoResults(actionsAndHints.hints, input, txt);
            return false;
        }
        actionsAndHints = actionsAndHints.deduped();
        if (actionsAndHints.actions.size() == 1) {
            actionsAndHints.actions.get(0).execute(controller);
            return true;
        }
        this.handleMultipleResults(actionsAndHints.actions, txt);
        return false;
    }

    private void handleNoResults(List<String> hints, String input, TextPrinter txt) {
        if (hints == null || hints.size() == 0) {
            String[] words = InputParser.splitIntoWords(input);
            txt.println("Come again?");
            return;
        }
        for (int i = 0; i < hints.size(); ++i) {
            if (i != 0) {
                txt.println();
            }
            txt.println(hints.get(i));
        }
    }

    private void handleMultipleResults(List<UserAction> results, TextPrinter txt) {
        this.launchMenu(new NumericTextMenu("Did you mean one of these?", results, txt, false));
    }

    public void launchMenu(NumericTextMenu menu) {
        this.currentMenu = menu;
        this.currentMenu.render();
    }
}

