/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgGlobal;
import GuiTool.Gui.InputOptionDialog;
import GuiTool.Gui.MutatePanel;
import GuiTool.Gui.ViewLexItemDialog;
import GuiTool.GuiLib.GridBag;
import gov.nih.nlm.nls.lvg.Lib.InputFilter;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InputPanel
extends JPanel {
    private static JTextField termField_ = null;
    private static JTextField fileField_ = null;
    private static LexItem lexItem_ = null;
    private static ViewLexItemDialog lexItemD_ = null;
    private static JFrame owner_ = null;
    private static InputPanel inputP_ = null;
    private static Box term_ = null;
    private static Box file_ = null;
    private static final long serialVersionUID = 5L;

    private InputPanel(JFrame owner) {
        owner_ = owner;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Inputs"));
        termField_ = new JTextField(40);
        termField_.setFont(new Font("Dialog", 0, 14));
        fileField_ = new JTextField(35);
        fileField_.setFont(new Font("Dialog", 0, 14));
        fileField_.setEditable(false);
        JButton optionB = new JButton("Options");
        JButton resetB = new JButton("Reset");
        JButton detailB = new JButton("Details");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(5, 3, 5, 3);
        GridBag.SetWeight(gbc, 100, 100);
        term_ = Box.createHorizontalBox();
        term_.add(new JLabel("Term: "));
        term_.add(termField_);
        term_.setVisible(LvgGlobal.inputFromScreen_);
        file_ = Box.createHorizontalBox();
        file_.add(new JLabel("File: "));
        file_.add(fileField_);
        file_.setVisible(!LvgGlobal.inputFromScreen_);
        GridBag.SetPosSize(gbc, 1, 1, 5, 1);
        this.add((Component)file_, gbc);
        GridBag.SetPosSize(gbc, 2, 1, 5, 1);
        this.add((Component)term_, gbc);
        gbc.anchor = 13;
        GridBag.SetPosSize(gbc, 3, 2, 1, 1);
        this.add((Component)optionB, gbc);
        gbc.anchor = 10;
        GridBag.SetPosSize(gbc, 4, 2, 1, 1);
        this.add((Component)resetB, gbc);
        gbc.anchor = 17;
        GridBag.SetPosSize(gbc, 5, 2, 1, 1);
        this.add((Component)detailB, gbc);
        optionB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InputOptionDialog.ShowDialog(owner_);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                termField_.setText("");
                InputOptionDialog.SetCategory(2047L);
                InputOptionDialog.SetInflection(0xFFFFFFL);
                InputOptionDialog.ResetCheckBox();
                InputOptionDialog.SetSourceToScreen();
            }
        });
        detailB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (LvgGlobal.inputFromScreen_) {
                    InputPanel.SetLexItem();
                    if (lexItemD_ == null) {
                        lexItemD_ = new ViewLexItemDialog(owner_, lexItem_, "LVG Input - LexItem Details", "Input LexItem Details");
                    } else {
                        lexItemD_.SetLexItem(lexItem_);
                    }
                    lexItemD_.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(owner_, "No detail information is available for file input!", "Input LexItem Details", 2);
                }
            }
        });
    }

    public static JPanel GetPanel(JFrame owner) {
        if (inputP_ == null) {
            inputP_ = new InputPanel(owner);
        }
        return inputP_;
    }

    public static void SetLexItem() {
        long inCat;
        String separator = LvgGlobal.separator_;
        String inLine = termField_.getText();
        int termFieldNum = InputOptionDialog.GetTermFieldNum();
        String term = InputFilter.GetInputTerm(inLine, separator, termFieldNum);
        if (MutatePanel.GetCurProgram() == 4) {
            term = inLine;
        }
        lexItem_.SetOriginalTerm(term);
        lexItem_.SetSourceTerm(term);
        int categoryFieldNum = InputOptionDialog.GetCategoryFieldNum();
        if (categoryFieldNum > 0) {
            inCat = InputFilter.GetInputCategory(inLine, separator, categoryFieldNum);
            lexItem_.SetSourceCategory(inCat);
        } else {
            inCat = InputOptionDialog.GetCategory();
            lexItem_.SetSourceCategory(inCat);
        }
        int inflectionFieldNum = InputOptionDialog.GetInflectionFieldNum();
        if (inflectionFieldNum > 0) {
            long inInfl = InputFilter.GetInputInflection(inLine, separator, inflectionFieldNum);
            lexItem_.SetSourceInflection(inInfl);
        } else {
            long inInfl = InputOptionDialog.GetInflection();
            lexItem_.SetSourceInflection(inInfl);
        }
    }

    public static LexItem GetLexItem() {
        InputPanel.SetLexItem();
        return lexItem_;
    }

    public static String GetInLine() {
        return termField_.getText();
    }

    public static JTextField GetTermField() {
        return termField_;
    }

    public static void SetFile(String filePath) {
        fileField_.setText(filePath);
    }

    public static void SetShowFile(boolean showTerm) {
        term_.setVisible(showTerm);
        file_.setVisible(!showTerm);
    }

    static {
        lexItem_ = new LexItem("", 2047L, 0xFFFFFFL);
    }
}

