/*
 * Decompiled with CFR 0.152.
 */
package GuiTool.Gui;

import GuiTool.Global.LvgDef;
import GuiTool.GuiComp.CategoryPanel;
import GuiTool.GuiComp.OkCancelResetAllButtonPanel;
import GuiTool.GuiLib.IntTextField;
import gov.nih.nlm.nls.lvg.Lib.CatInfl;
import gov.nih.nlm.nls.lvg.Lib.Category;
import gov.nih.nlm.nls.lvg.Lib.Inflection;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CategoryDialog
extends JDialog
implements ActionListener {
    private static JCheckBox[] cb_ = new JCheckBox[LvgDef.CATEGORY_NUM];
    private static IntTextField catField_ = null;
    private static long categoryValue_ = 0L;
    private static String category_ = null;
    private static CategoryDialog catD_ = null;
    private static final long serialVersionUID = 5L;

    private CategoryDialog(JFrame owner, String label, String title) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.setSize(350, 450);
        JPanel textP = new JPanel();
        textP.setLayout(new BoxLayout(textP, 0));
        catField_ = new IntTextField(0, 4);
        catField_.setEditable(false);
        textP.add(new JLabel(label));
        textP.add(catField_);
        CategoryPanel catP = new CategoryPanel(this, 1);
        cb_ = catP.GetCheckBox();
        OkCancelResetAllButtonPanel buttonP = new OkCancelResetAllButtonPanel();
        JButton okB = buttonP.GetOkButton();
        JButton cancelB = buttonP.GetCancelButton();
        JButton resetB = buttonP.GetResetButton();
        JButton allB = buttonP.GetAllButton();
        JPanel centerP = new JPanel();
        centerP.add(textP);
        centerP.add(catP);
        this.getContentPane().add((Component)centerP, "Center");
        this.getContentPane().add((Component)buttonP, "South");
        okB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                category_ = Long.toString(categoryValue_);
                CategoryDialog.this.setVisible(false);
            }
        });
        cancelB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                category_ = null;
                CategoryDialog.this.setVisible(false);
            }
        });
        resetB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
                    cb_[i].setSelected(false);
                }
                categoryValue_ = 0L;
                catField_.setText(Long.toString(categoryValue_));
            }
        });
        allB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
                    cb_[i].setSelected(true);
                }
                categoryValue_ = 2047L;
                catField_.setText(Long.toString(categoryValue_));
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        categoryValue_ = 0L;
        for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
            if (!cb_[i].isSelected()) continue;
            categoryValue_ |= LvgDef.CATEGORY_VALUE[i];
        }
        catField_.setText(Long.toString(categoryValue_));
    }

    public String GetValueStr() {
        return category_;
    }

    public long GetValue() {
        return categoryValue_;
    }

    public void SetValueStr(String valueStr) {
        if (valueStr != null) {
            try {
                category_ = valueStr;
                categoryValue_ = Long.parseLong(category_);
                catField_.setText(category_);
                for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
                    boolean selected = (categoryValue_ & LvgDef.CATEGORY_VALUE[i]) > 0L;
                    cb_[i].setSelected(selected);
                }
            }
            catch (Exception e) {
                category_ = "";
                catField_.setText(category_);
                for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
                    cb_[i].setSelected(false);
                }
            }
        } else {
            category_ = "";
            catField_.setText(category_);
            for (int i = 0; i < LvgDef.CATEGORY_NUM; ++i) {
                cb_[i].setSelected(false);
            }
        }
    }

    public static String ShowDialog(JFrame owner, long category) {
        if (catD_ == null) {
            catD_ = new CategoryDialog(owner, "Value of selected category: ", "Category Selection");
        }
        catD_.SetValueStr(Long.toString(category));
        catD_.setVisible(true);
        return catD_.GetValueStr();
    }

    public static void ShowDialog(JFrame owner, JTextField valueT) {
        if (catD_ == null) {
            catD_ = new CategoryDialog(owner, "Value of selected category: ", "Category Selection");
        }
        catD_.SetValueStr(valueT.getText());
        catD_.setVisible(true);
        if (catD_.GetValueStr() != null) {
            valueT.setText(catD_.GetValueStr());
        }
    }

    public static void ShowDialog(JFrame owner, JTextField valueT, JTextField inflValueT) {
        if (catD_ == null) {
            catD_ = new CategoryDialog(owner, "Value of selected category: ", "Category Selection");
        }
        catD_.SetValueStr(valueT.getText());
        catD_.setVisible(true);
        if (catD_.GetValueStr() != null) {
            valueT.setText(catD_.GetValueStr());
            long inflValue = CategoryDialog.CalInflectionValue(catD_.GetValue());
            inflValueT.setText(Long.toString(inflValue));
        }
    }

    private static long CalInflectionValue(long cat) {
        long inflValue = 0L;
        Vector<Long> catValues = Category.ToValues(cat);
        for (int i = 0; i < catValues.size(); ++i) {
            long curCat = catValues.elementAt(i);
            for (int j = 0; j < LvgDef.INFLECTION_NUM; ++j) {
                if (!CatInfl.IsRelated(curCat, Inflection.GetBitValue(j))) continue;
                inflValue |= LvgDef.INFLECTION_VALUE[j];
            }
        }
        return inflValue;
    }
}

