/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.xmlrealiser;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import simplenlg.framework.DocumentElement;
import simplenlg.framework.NLGElement;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.NIHDBLexicon;
import simplenlg.lexicon.XMLLexicon;
import simplenlg.realiser.english.Realiser;
import simplenlg.xmlrealiser.Recording;
import simplenlg.xmlrealiser.UnWrapper;
import simplenlg.xmlrealiser.XMLRealiserException;
import simplenlg.xmlrealiser.wrapper.NLGSpec;
import simplenlg.xmlrealiser.wrapper.RecordSet;
import simplenlg.xmlrealiser.wrapper.RequestType;
import simplenlg.xmlrealiser.wrapper.XmlDocumentElement;

public class XMLRealiser {
    static String lexDB = null;
    static Lexicon lexicon = null;
    static LexiconType lexiconType = null;
    static Recording record = null;

    public static String main(Object[] args) throws XMLRealiserException {
        OpCode opCode;
        if (args == null || args.length == 0) {
            throw new XMLRealiserException("invalid args");
        }
        int argx = 0;
        String input = "";
        String output = "OK";
        String opCodeStr = (String)args[argx++];
        try {
            opCode = Enum.valueOf(OpCode.class, opCodeStr);
        }
        catch (IllegalArgumentException ex) {
            throw new XMLRealiserException("invalid args");
        }
        switch (opCode) {
            case realise: {
                if (args.length <= argx) {
                    throw new XMLRealiserException("invalid args");
                }
                input = (String)args[argx++];
                StringReader reader = new StringReader(input);
                RequestType request = XMLRealiser.getRequest(reader);
                output = XMLRealiser.realise(request.getDocument());
                break;
            }
            case setLexicon: {
                LexiconType lexType;
                if (args.length <= argx + 1) {
                    throw new XMLRealiserException("invalid setLexicon args");
                }
                String lexTypeStr = (String)args[argx++];
                String lexFile = (String)args[argx++];
                try {
                    lexType = Enum.valueOf(LexiconType.class, lexTypeStr);
                }
                catch (IllegalArgumentException ex) {
                    throw new XMLRealiserException("invalid args");
                }
                XMLRealiser.setLexicon(lexType, lexFile);
                break;
            }
            case startRecording: {
                if (args.length <= argx) {
                    throw new XMLRealiserException("invalid args");
                }
                String path = (String)args[argx++];
                XMLRealiser.startRecording(path);
                break;
            }
            case stopRecording: {
                if (record == null) break;
                output = record.GetRecordingFile();
                try {
                    record.finish();
                    break;
                }
                catch (Exception e) {
                    throw new XMLRealiserException("xml writing error " + e.getMessage());
                }
            }
            case noop: {
                break;
            }
            default: {
                throw new XMLRealiserException("invalid op code " + opCodeStr);
            }
        }
        if (opCode == OpCode.realise) {
            // empty if block
        }
        return output;
    }

    public static void setLexicon(LexiconType lexType, String lexFile) {
        if (lexiconType != null && lexicon != null && lexType == lexiconType) {
            return;
        }
        if (lexicon != null) {
            lexicon.close();
            lexicon = null;
            lexiconType = null;
        }
        if (lexType == LexiconType.XML) {
            lexicon = new XMLLexicon(lexFile);
        } else if (lexType == LexiconType.NIHDB) {
            lexicon = new NIHDBLexicon(lexFile);
        } else if (lexType == LexiconType.DEFAULT) {
            lexicon = Lexicon.getDefaultLexicon();
        }
        lexiconType = lexType;
    }

    public static RequestType getRequest(Reader input) throws XMLRealiserException {
        NLGSpec spec = UnWrapper.getNLGSpec(input);
        RequestType request = spec.getRequest();
        if (request == null) {
            throw new XMLRealiserException("Must have Request element");
        }
        return request;
    }

    public static RecordSet getRecording(Reader input) throws XMLRealiserException {
        NLGSpec spec = UnWrapper.getNLGSpec(input);
        RecordSet recording = spec.getRecording();
        if (recording == null) {
            throw new XMLRealiserException("Must have Recording element");
        }
        return recording;
    }

    public static String realise(XmlDocumentElement wt) throws XMLRealiserException {
        String output = "";
        if (wt != null) {
            try {
                UnWrapper w;
                DocumentElement t;
                if (lexicon == null) {
                    lexicon = Lexicon.getDefaultLexicon();
                }
                if ((t = (w = new UnWrapper(lexicon)).UnwrapDocumentElement(wt)) != null) {
                    Realiser r = new Realiser(lexicon);
                    r.initialise();
                    NLGElement tr = r.realise(t);
                    output = tr.getRealisation();
                }
            }
            catch (Exception e) {
                throw new XMLRealiserException("NLG XMLRealiser Error", e);
            }
        }
        return output;
    }

    public static void startRecording(String path) throws XMLRealiserException {
        if (record != null) {
            try {
                record.finish();
            }
            catch (Exception e) {
                throw new XMLRealiserException("NLG XMLRealiser Error", e);
            }
        }
        record = new Recording(path);
        try {
            record.start();
        }
        catch (IOException e) {
            throw new XMLRealiserException("NLG XMLRealiser Error", e);
        }
    }

    public static String stopRecording() throws XMLRealiserException {
        String file = "";
        if (record != null) {
            file = record.GetRecordingFile();
            try {
                record.finish();
            }
            catch (Exception e) {
                throw new XMLRealiserException("NLG XMLRealiser Error", e);
            }
        }
        return file;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LexiconType {
        DEFAULT,
        XML,
        NIHDB;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpCode {
        noop,
        realise,
        setLexicon,
        startRecording,
        stopRecording;

    }
}

