/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.framework;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import simplenlg.framework.NLGElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListElement
extends NLGElement {
    public ListElement() {
    }

    public ListElement(List<NLGElement> components) {
        this();
        this.addComponents(components);
    }

    @Override
    public List<NLGElement> getChildren() {
        return this.getFeatureAsElementList("components");
    }

    public ListElement(NLGElement newComponent) {
        this();
        this.addComponent(newComponent);
    }

    public void addComponent(NLGElement newComponent) {
        List<NLGElement> components = this.getFeatureAsElementList("components");
        if (components == null) {
            components = new ArrayList<NLGElement>();
        }
        this.setFeature("components", components);
        components.add(newComponent);
    }

    public void addComponents(List<NLGElement> newComponents) {
        List<NLGElement> components = this.getFeatureAsElementList("components");
        if (components == null) {
            components = new ArrayList<NLGElement>();
        }
        this.setFeature("components", components);
        components.addAll(newComponents);
    }

    public void setComponents(List<NLGElement> newComponents) {
        this.setFeature("components", newComponents);
    }

    @Override
    public String toString() {
        return this.getChildren().toString();
    }

    @Override
    public String printTree(String indent) {
        String thisIndent = indent == null ? " |-" : indent + " |-";
        String childIndent = indent == null ? " | " : indent + " | ";
        String lastIndent = indent == null ? " \\-" : indent + " \\-";
        String lastChildIndent = indent == null ? "   " : indent + "   ";
        StringBuffer print = new StringBuffer();
        print.append("ListElement: features={");
        Map<String, Object> features = this.getAllFeatures();
        for (String eachFeature : features.keySet()) {
            print.append(eachFeature).append('=').append(features.get(eachFeature).toString()).append(' ');
        }
        print.append("}\n");
        List<NLGElement> children = this.getChildren();
        int length = children.size() - 1;
        int index = 0;
        for (index = 0; index < length; ++index) {
            print.append(thisIndent).append(children.get(index).printTree(childIndent));
        }
        if (length >= 0) {
            print.append(lastIndent).append(children.get(length).printTree(lastChildIndent));
        }
        return print.toString();
    }

    public int size() {
        return this.getChildren().size();
    }

    public NLGElement getFirst() {
        List<NLGElement> children = this.getChildren();
        return children == null ? null : children.get(0);
    }
}

