/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lexCheck.Cat.Noun;

import gov.nih.nlm.nls.lexCheck.Lib.CheckFormat;
import java.util.HashSet;
import java.util.StringTokenizer;

public class CheckFormatNounVariants
implements CheckFormat {
    private static final int LEGAL_ARGUMENT_NUM = 5;
    private static HashSet<String> groupNounArgument_ = new HashSet(5);
    private static final int LEGAL_FILLER_NUM = 11;
    private static HashSet<String> filler_ = new HashSet(11);

    @Override
    public boolean IsLegalFormat(String filler) {
        boolean flag = filler_.contains(filler);
        if (!flag) {
            if (filler.startsWith("irreg|") && filler.endsWith("|")) {
                StringTokenizer buf = new StringTokenizer(filler, "|");
                int pipeNum = 0;
                while (buf.hasMoreTokens()) {
                    String token = buf.nextToken();
                    ++pipeNum;
                }
                flag = pipeNum == 3;
            } else if (filler.startsWith("group(")) {
                flag = this.CheckNounGroupArgument(filler);
            }
        }
        return flag;
    }

    private boolean CheckNounGroupArgument(String argument) {
        boolean flag = groupNounArgument_.contains(argument);
        if (!flag && argument.startsWith("group(irreg|") && argument.endsWith("|)")) {
            StringTokenizer buf = new StringTokenizer(argument, "|");
            int pipeNum = 0;
            while (buf.hasMoreTokens()) {
                String token = buf.nextToken();
                ++pipeNum;
            }
            flag = pipeNum == 4;
        }
        return flag;
    }

    static {
        groupNounArgument_.add("group(reg)");
        groupNounArgument_.add("group(irreg)");
        groupNounArgument_.add("group(glreg)");
        groupNounArgument_.add("group(metareg)");
        groupNounArgument_.add("group(sing)");
        filler_.add("reg");
        filler_.add("glreg");
        filler_.add("metareg");
        filler_.add("irreg|");
        filler_.add("sing");
        filler_.add("plur");
        filler_.add("inv");
        filler_.add("group()");
        filler_.add("uncount");
        filler_.add("groupuncount");
    }
}

