/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.timecraft;

import com.fabriziopolo.textapp.InteractiveTextUiSwingImpl;
import com.fabriziopolo.textcraft.app.Game;
import com.fabriziopolo.textcraft.app.TextCraftAppController;
import com.fabriziopolo.timecraft.game.AlphaIslandGame;
import com.fabriziopolo.timecraft.game.TimeLapseGame;
import com.fabriziopolo.timecraft.game.TutorialGame;
import javax.swing.SwingUtilities;

public class TextCraft {
    private static final int STARTUP_EPISODE = 1;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Game game = TextCraft.getGameFromEpisode(1);
                InteractiveTextUiSwingImpl ui = InteractiveTextUiSwingImpl.createAndLaunch();
                TextCraftAppController controller = new TextCraftAppController(game);
                controller.setUi(ui);
                ui.setInputListener(controller);
                ui.setClosingHandler(ignore -> controller.onClose(false));
                controller.play();
            }
        });
    }

    public static Game getGameFromEpisode(int episode) {
        switch (episode) {
            case 0: {
                return new TutorialGame();
            }
            case 1: {
                return new AlphaIslandGame();
            }
            case 2: {
                return new TimeLapseGame();
            }
        }
        throw new IllegalArgumentException();
    }
}

