/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.goability;

import com.fabriziopolo.textcraft.events.notification.PlayerNotificationEvent;
import com.fabriziopolo.textcraft.events.position.PlayerExaminesSurroundingsEvent;
import com.fabriziopolo.textcraft.nlg.NounPhraseWithArticle;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.Prepositions;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.Simulation;
import com.fabriziopolo.textcraft.states.goability.GoHandler;
import com.fabriziopolo.textcraft.states.goability.GoableState;
import com.fabriziopolo.textcraft.states.position.PositionState;
import com.fabriziopolo.textcraft.states.position.PositionStateBuilder;
import com.fabriziopolo.textcraft.states.position.SpacialRelationship;
import com.fabriziopolo.textcraft.states.room.RoomState;
import java.util.Map;

public class DefaultGoHandler
implements GoHandler {
    public static final DefaultGoHandler instance = new DefaultGoHandler();

    @Override
    public Noun getPlaceToGo(Noun place, SpacialRelationship spacialRelationship, Frame frame) {
        return place;
    }

    @Override
    public void handleGo(Noun goer, SpacialRelationship spacialRelationship, SpacialRelationship reverseSpacialRelationship, Simulation simulation, PositionStateBuilder partialState, Noun place) {
        GoHandler redirectedGoHandler;
        Frame frame = simulation.getCurrentFrame();
        PositionState positionState = PositionState.get(frame);
        Map<SpacialRelationship, Noun> entrances = positionState.getEntrances(place);
        if (entrances == null || !entrances.containsKey(spacialRelationship)) {
            this.handleCantGo(goer, spacialRelationship, place, simulation);
            return;
        }
        Noun placeToGo = this.getPlaceToGo(place, spacialRelationship, frame);
        if (placeToGo != place && (redirectedGoHandler = GoableState.get(frame).getGoHandler(placeToGo, spacialRelationship)) != null) {
            redirectedGoHandler.handleGo(goer, spacialRelationship, reverseSpacialRelationship, simulation, partialState, placeToGo);
            return;
        }
        if (placeToGo == null) {
            this.handleCantGo(goer, spacialRelationship, place, simulation);
            return;
        }
        this.onDoGo(goer, spacialRelationship, reverseSpacialRelationship, place, placeToGo, partialState, simulation);
    }

    public void onDoGo(Noun goer, SpacialRelationship spacialRelationship, SpacialRelationship reverseSpacialRelationship, Noun place, Noun placeToGo, PositionStateBuilder partialState, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        if (spacialRelationship.isPreposition()) {
            assert (reverseSpacialRelationship.isPreposition());
            Preposition preposition = spacialRelationship.getPreposition();
            PlayerNotificationEvent.post(goer, simulation, "You go " + preposition + " " + NounPhraseWithArticle.the(place.getDefaultPerception(frame)) + ".\n");
            partialState.put(goer, preposition, reverseSpacialRelationship.getPreposition(), placeToGo);
            PlayerExaminesSurroundingsEvent.post(goer, simulation);
        } else {
            Preposition reversePreposition;
            Preposition preposition;
            PlayerNotificationEvent.post(goer, simulation, "You go " + spacialRelationship.getDirection().getContextFreeDescription() + ".\n");
            Noun floor = RoomState.get(frame).getFloor(placeToGo);
            if (floor != null) {
                placeToGo = floor;
                preposition = Prepositions.on;
                reversePreposition = Prepositions.under;
            } else {
                preposition = Prepositions.at;
                reversePreposition = null;
            }
            partialState.put(goer, preposition, reversePreposition, placeToGo);
            this.onArrival(goer, spacialRelationship, place, placeToGo, partialState, simulation);
        }
    }

    public void onArrival(Noun goer, SpacialRelationship spacialRelationship, Noun place, Noun placeToGo, PositionStateBuilder partialState, Simulation simulation) {
        if (spacialRelationship.isDirection()) {
            PlayerExaminesSurroundingsEvent.post(goer, spacialRelationship.getDirection(), simulation);
        } else {
            PlayerExaminesSurroundingsEvent.post(goer, simulation);
        }
    }

    public void handleCantGo(Noun goer, SpacialRelationship spacialRelationship, Noun place, Simulation simulation) {
        Frame frame = simulation.getCurrentFrame();
        if (!spacialRelationship.isPreposition()) {
            PlayerNotificationEvent.post(goer, simulation, "You can't go " + spacialRelationship.getDirection() + " from here.");
            throw new RuntimeException("Not Implemented");
        }
        PlayerNotificationEvent.post(goer, simulation, "You can't go " + spacialRelationship.getPreposition() + " " + NounPhraseWithArticle.the(place.getDefaultPerception(frame)) + ".");
    }
}

