/*
 * Decompiled with CFR 0.152.
 */
package com.fabriziopolo.textcraft.states.description;

import com.fabriziopolo.textcraft.nlg.GroupedCollectionNounPhrase;
import com.fabriziopolo.textcraft.nlg.IndependentWithAdverbialClause;
import com.fabriziopolo.textcraft.nlg.MultipleSentences;
import com.fabriziopolo.textcraft.nlg.Preposition;
import com.fabriziopolo.textcraft.nlg.PureAdverbialClause;
import com.fabriziopolo.textcraft.nlg.Sentences;
import com.fabriziopolo.textcraft.nlg.SingleClauseSentence;
import com.fabriziopolo.textcraft.nlg.ThereExistsClause;
import com.fabriziopolo.textcraft.simulation.Frame;
import com.fabriziopolo.textcraft.simulation.Noun;
import com.fabriziopolo.textcraft.simulation.perception.Perceiver;
import com.fabriziopolo.textcraft.states.position.AbstractTreeAlgorithm;
import com.fabriziopolo.textcraft.states.position.PositionState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ContainedObjectsDescriptionBuilder {
    public static Sentences getContainedObjectsDescription(Noun root, Perceiver perceiver, Frame frame) {
        TreeAlgorithm treeAlgorithm = new TreeAlgorithm(perceiver, frame);
        treeAlgorithm.traverseDepthFirst(root, frame);
        return treeAlgorithm.getResultingSentences();
    }

    private static final class TreeAlgorithm
    extends AbstractTreeAlgorithm {
        private final Perceiver perceiver;
        private final List<Noun> perceivableNouns;
        private final List<Sentences> sentences = new ArrayList<Sentences>();

        private TreeAlgorithm(Perceiver perceiver, Frame frame) {
            this.perceiver = perceiver;
            this.perceivableNouns = perceiver.getPerceivableNouns(frame);
        }

        public Sentences getResultingSentences() {
            return new MultipleSentences(new ArrayList<Sentences>(this.sentences));
        }

        @Override
        protected boolean onParent(Noun parent, Set<Noun> children, Frame frame) {
            if (children == null) {
                return true;
            }
            List<Noun> visibleChildren = children.stream().filter(child -> this.perceivableNouns.contains(child)).collect(Collectors.toList());
            PositionState positionState = PositionState.get(frame);
            Map<Preposition, List<Noun>> nounsByPreposition = visibleChildren.stream().collect(Collectors.groupingBy(positionState::getPreposition));
            this.sentences.add(this.getSentence(parent, visibleChildren, frame));
            nounsByPreposition.remove(null);
            nounsByPreposition.forEach((preposition, nouns) -> this.sentences.add(this.getSentence(parent, (Preposition)preposition, (Collection<Noun>)nouns, frame)));
            return true;
        }

        private Sentences getSentence(Noun parent, Preposition preposition, Collection<Noun> children, Frame frame) {
            return null;
        }

        private Sentences getSentence(Noun parent, Collection<Noun> children, Frame frame) {
            List perceptions = children.stream().map(noun -> this.perceiver.getPerceptionOf((Noun)noun, frame)).filter(perception -> perception != null).collect(Collectors.toList());
            GroupedCollectionNounPhrase nounsPerception = GroupedCollectionNounPhrase.create(perceptions);
            ThereExistsClause thereExistsClause = new ThereExistsClause(nounsPerception);
            IndependentWithAdverbialClause fullSentenceClause = IndependentWithAdverbialClause.createInverted(thereExistsClause, new PureAdverbialClause("here"));
            SingleClauseSentence thereExistsSentences = new SingleClauseSentence(fullSentenceClause);
            return thereExistsSentences;
        }
    }
}

