require_relative "../classes.rb"

class TestStrength < BaseBehaviorTestCase

  def setup
    super
    @subject = AR::Game::Player.new
    test_init_gauges
  end


  def test_strength_increases_health

    health = @subject.gauge("health")
    prev_value = health.modified_current
    e = AR::Events::GaugeChanged.new gauge: @subject.gauge("strength"), amount: 10
    results = e.resolve!
    results.map(&:resolve!)
    assert_equal prev_value+20, health.modified_current
  end


end

