module AR::Game::BuffBehavior
  #add attr_accessor properties here... 
  #if you don't need them serialized on save
  #
  #

  attr_accessor :on_applied
  attr_accessor :on_removed

  #...initialize them here
  def self.init ar_object 
    ar_object.class.attr_serializeable :state
    ar_object.class.attr_serializeable :subject_id



    #stores things like counters and such
    ar_object.state = {}
  end

  def subject
    self.world.find self.subject_id
  end

  def subject=(obj)
    self.subject_id = obj.id
  end

  def self.extended ar_object
    self.init ar_object
    ar_object.resolutions << call_applied_on_applied
    ar_object.resolutions << call_removed_on_removed
  end 

  def self.call_applied_on_applied
    AR::Events::Resolution.new event_class: AR::Events::BuffApplied, as: "buff" do |e|
      #maybe can return events?
      e.buff.on_applied.call(e.subject)
    end
  end

  def self.call_removed_on_removed
    AR::Events::Resolution.new event_class: AR::Events::BuffRemoved, as: "buff" do |e|
      buff = e.buff
      #maybe can return events?
      e.buff.on_removed.call(e.subject)
    end
  end



  def on subject
    self.subject_id=subject.id
  end


  #add more methods here

end
