module AR
  module Game

    class Sword < PieceOfEquipment
      def initialize id=nil
        super 
        add_story_implement InspectedImplement.new
        self.article = "your"
        self.noun = "sword"
        self.slot = "main_hand"

        self.on_equipped = Proc.new do |equipper|
          equipper.attack_techniques.push (AR::Game::SlashTech.new)
          nil
        end

        self.on_unequipped = Proc.new do |equipper|
          tech = equipper.attack_techniques.select{|t| t.class == AR::Game::SlashTech}.last
          equipper.attack_techniques.delete tech
          nil
        end

      end

      class SwordImplement < AR::Game::StoryBehavior::StoryImplement
      end
      class SwordStory <AR::Game::StoryBehavior::Story
      end

      class InspectedImplement < SwordImplement
        def initialize stories = [] 
          super
          story = SwordStory.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret="Your sword looks like it always does: worn, chipped, and worse for wear. Still, it's gotten you this far; it would just be wrong to toss it now."
            end
            ret
          end

          add_story story
          end


      end


    end

  end
end
