module AR
  module Game

    class OldManCourtyard < Scene
      def initialize id=nil
        super 
        self.noun = "courtyard"
        #add_behavior AR::Game::SomeBehavior
        add_story_implement StoryImplement.new
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "This courtyard feels very welcoming. Birds flutter by and land on an old bird bath, which is being split apart by ivy. Between the cobblestones under you turf bulges out."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The plants here are pretty unkempt, but it doesn't feel to take away from the character of it.  You can see the home of the old man here, which is built into the root structure of a large tree.  Smoke is eminating from a jagged, crude chimney."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end
    end



  end
end
