module AR
  module Game

    class IronSword < Weapon 
      def initialize id=nil
        super 
        #add_behavior AR::Game::SomeBehavior
        add_story_implement StoryImplement.new
        self.noun = "iron sword"
        self.slot = :main_hand
        self.damage_dice = 12

        self.on_equipped = Proc.new do |equipper|
          equipper.attack_techniques.unshift (AR::Game::SlashTech.new)
          nil
        end

        self.on_unequipped = Proc.new do |equipper|
          tech = equipper.attack_techniques.select{|t| t.class == AR::Game::SlashTech}.last
          equipper.attack_techniques.delete tech
          nil
        end


      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "#{e.discovered.placement.capitalize}, an iron sword catches your attention."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The sword has a few specks of rust, but is still great shape.  This would serve you much better than one made of chitin."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

        end
      end

    end



  end
end


