module AR
  module Game

    class IronDagger < Weapon
      def initialize id=nil
        super 
        #add_behavior AR::Game::SomeBehavior
        add_story_implement StoryImplement.new
        self.noun = "iron dagger"
        self.slot = :main_hand 
        self.damage_dice = 8

        self.on_equipped = Proc.new do |equipper|
          equipper.attack_techniques.unshift (AR::Game::StabTech.new)
          nil
        end

        self.on_unequipped = Proc.new do |equipper|
          tech = equipper.attack_techniques.select{|t| t.class == AR::Game::StabTech}.last
          equipper.attack_techniques.delete tech
          nil
        end




      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end
      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super
          #add stories like this:
          #s = Story.new when: AR::Events::Event, as: "participant" do |e|
          #end
          #add_story s

          story =  Story.new when: AR::Events::DiscoveryMadeEvent, as: "discovered" do |e|
            if e.perceiver == e.engine.world.player
              ret = "#{e.discovered.placement.capitalize}, an iron dagger catches your attention."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The dagger has a few specks of rust, but is still great shape.  This would serve you much better than one made of chitin."
            else 
              ret = ""
            end
            ret 
          end
          add_story story


        end
      end

    end



  end
end

