module AR
  module Game

    class Forest03 < Scene
      def initialize id=nil
        super 
        self.noun = "forest"
        self.add_story_implement StoryImplement.new

        spawner = AR::Events::Resolution.new event_class: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e| 
          g = e.gateway 
          unless g.nil?
            if g.class.to_s.include? "Forest" 
              m = GiantBeetle.new "#{self.id}_beetle_#{AR::Game::ARObject.gen_id}"
              m.subscribe!
              init_gs = AR::Events::GaugesInitialized.new gauge_manager: m 
              init_gs.resolve!

              m.gauge("strength").change_current_and_max 1
              m.gauge("strength").manual_child_sync

              e.engine.after_step AR::Events::ARObjectEnteredInhabitableEvent.new enterer: m, inhabitable: e.inhabitable, dont_narrate: true
              e.engine.after_step AR::Events::NarrationEvent.new narration: "You hear a disturbing rustling in the bushes, coming from the west.  Out of them crawls a gigantic beetle, which appears to be foraging.  You get a shot of adrenaline." 
              nil
            end
          end
        end
        self.resolutions.push(spawner)

        #add_behavior AR::Game::SomeBehavior
      end


      #sort of just a way to 'include' these classes, so you don't
      #need to fully qualify them.  There must be a better way...
      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "This is a refreshing clearing in the forest.  The terrain is rough with stones, but you step over them with relative ease."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "You notice a thin, well-trodden trail that leads into the underbrush. Perhaps a rabbit trail?  Over the trees to the east, you can see the top of a mountain."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end

    end



  end
end
