module AR
  module Game

    class Forest02 < Scene
      def initialize id=nil
        super 
        self.noun = "forest"
        #add_behavior AR::Game::SomeBehavior

        add_story_implement StoryImplement.new
      end


      class Story < AR::Game::StoryBehavior::Story
      end

      class StoryImplement < AR::Game::StoryBehavior::StoryImplement
        def initialize stories=[]
          super

          story =  Story.new when: AR::Events::ARObjectEnteredInhabitableEvent, as: "inhabitable" do |e|
            if e.enterer == e.engine.world.player
              ret = "The forest trees bristle in the breeze as you step along the path."
            else 
              ret = ""
            end
            ret 
          end
          add_story story

          story =  Story.new when: AR::Events::DiscoverableInspectedEvent, as: "discoverable" do |e|
            if e.inspector == e.engine.world.player
              ret = "The trees here are more spaced than in the rest of the forest.  Several boulders fill the gaps where trees might have been."
            else 
              ret = ""
            end
            ret 
          end
          add_story story
        end
      end

    end




  end
end
