class AR::Events::DiscoveryMadeEvent < AR::Events::Event
  attr_participant :perceiver, :discovered

  def initialize params
    super params
  end 

  def default_story
    player = engine.world.player
    if perceiver == player and !(discovered.is_a? AR::Game::Scene) and !(discovered == player)
      "You can now see #{discovered.name}."
    end
  end

end
